/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security;

import javax.xml.rpc.Stub;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.GSIConstants;
import org.globus.wsrf.impl.security.TestConstants;
import org.globus.wsrf.impl.security.authorization.Authorization;
import org.globus.wsrf.impl.security.authorization.HostAuthorization;
import org.globus.wsrf.impl.security.authorization.NoAuthorization;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityDescriptor;
import org.globus.wsrf.test.GridTestCase;
import org.globus.wsrf.tests.security.CreateResourceResponse;
import org.globus.wsrf.tests.security.GsiSec;
import org.globus.wsrf.tests.security.GsiSecConvDeleg;
import org.globus.wsrf.tests.security.GsiSecConvIntegrity;
import org.globus.wsrf.tests.security.GsiSecConvOnly;
import org.globus.wsrf.tests.security.GsiSecConvPrivacy;
import org.globus.wsrf.tests.security.GsiSecMsgIntegrity;
import org.globus.wsrf.tests.security.GsiSecMsgOnly;
import org.globus.wsrf.tests.security.GsiSecMsgPrivacy;
import org.globus.wsrf.tests.security.SecurityTestPortType;
import org.globus.wsrf.tests.security.service.SecurityTestServiceAddressingLocator;

public class SecureServiceAccessTest
extends GridTestCase {
    static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$SecureServiceAccessTest == null ? (class$org$globus$wsrf$impl$security$SecureServiceAccessTest = SecureServiceAccessTest.class$("org.globus.wsrf.impl.security.SecureServiceAccessTest")) : class$org$globus$wsrf$impl$security$SecureServiceAccessTest).getName());
    static EndpointReferenceType testServiceEPR = null;
    static String CLIENT_DESC_FILE = "org/globus/wsrf/impl/security/client-security-config.xml";
    static String HOST_CLIENT_DESC_FILE = "org/globus/wsrf/impl/security/host-client-security-config.xml";
    Authorization authz = TestConstants.getConfiguredClientAuthz();
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$SecureServiceAccessTest;

    public SecureServiceAccessTest(String name) {
        super(name);
        System.out.println("Authz is " + this.authz.getClass().getName());
    }

    public static Test suite() {
        return new TestSuite(class$org$globus$wsrf$impl$security$SecureServiceAccessTest == null ? (class$org$globus$wsrf$impl$security$SecureServiceAccessTest = SecureServiceAccessTest.class$("org.globus.wsrf.impl.security.SecureServiceAccessTest")) : class$org$globus$wsrf$impl$security$SecureServiceAccessTest);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SecureServiceAccessTest.suite());
    }

    public void testSecureAccess() throws Exception {
        SecureServiceAccessTest.assertTrue((TEST_CONTAINER != null ? 1 : 0) != 0);
        String testServiceAddrs = TEST_CONTAINER.getBaseURL() + "SecurityTestService";
        EndpointReferenceType testServiceEPR = new EndpointReferenceType(new URI(testServiceAddrs));
        this.serviceSecurityTest(testServiceEPR);
        this.resourceSecurityTest(testServiceEPR);
        SecurityTestServiceAddressingLocator locator = new SecurityTestServiceAddressingLocator();
        SecurityTestPortType port = locator.getSecurityTestPortTypePort(testServiceEPR);
        port.setServiceAuthz(null);
        this.containerSecDescTest(testServiceEPR);
        port.setServiceAuthz("self");
        this.setCredsFromContextTest(testServiceEPR);
        port.setServiceAuthz("gridmap");
        SecurityTestPortType testPort = locator.getSecurityTestPortTypePort(testServiceEPR);
        logger.debug((Object)"No Auth tests");
        this.secureInvocations(testPort, false, false, false, false, false, false, false, false);
        this.setGSISecMsg(testPort, true);
        boolean exp = true;
        try {
            testPort.noAuth(null);
        }
        catch (Exception e) {
            logger.error((Object)e);
            exp = false;
        }
        SecureServiceAccessTest.assertTrue((boolean)exp);
        exp = false;
        try {
            testPort.gsiSecMsgOnly(new GsiSecMsgOnly());
        }
        catch (Exception e) {
            if (e.getMessage().indexOf("is not authorized") != -1) {
                exp = true;
            }
            logger.error((Object)e);
        }
        SecureServiceAccessTest.assertTrue((boolean)exp);
    }

    private void containerSecDescTest(EndpointReferenceType testEPR) throws Exception {
        boolean expOccured;
        block2: {
            SecurityTestServiceAddressingLocator locator = new SecurityTestServiceAddressingLocator();
            SecurityTestPortType testPort = locator.getSecurityTestPortTypePort(testEPR);
            CreateResourceResponse response = testPort.createResource(true);
            EndpointReferenceType res1EPR = response.getEndpointReference();
            SecurityTestPortType res1Port = locator.getSecurityTestPortTypePort(res1EPR);
            this.setGSISecConv(res1Port, true, false);
            expOccured = false;
            try {
                res1Port.alterSecurityDesc(null);
                SecureServiceAccessTest.fail((String)"Did not fail as expected");
            }
            catch (Exception exp) {
                if (exp.getMessage().indexOf("No gridmap file") == -1) break block2;
                expOccured = true;
            }
        }
        SecureServiceAccessTest.assertTrue((boolean)expOccured);
    }

    private void setCredsFromContextTest(EndpointReferenceType testEPR) throws Exception {
        SecurityTestServiceAddressingLocator locator = new SecurityTestServiceAddressingLocator();
        SecurityTestPortType testPort = locator.getSecurityTestPortTypePort(testEPR);
        CreateResourceResponse response = testPort.createResource(true);
        EndpointReferenceType res1EPR = response.getEndpointReference();
        SecurityTestPortType res1Port = locator.getSecurityTestPortTypePort(res1EPR);
        this.setGSISecConv(res1Port, true, false);
        res1Port.alterSecurityDesc("credFromContext");
    }

    public void serviceSecurityTest(EndpointReferenceType testEPR) throws Exception {
        SecurityTestServiceAddressingLocator locator = new SecurityTestServiceAddressingLocator();
        SecurityTestPortType testPort = locator.getSecurityTestPortTypePort(testEPR);
        logger.debug((Object)"No Auth tests");
        this.secureInvocations(testPort, false, false, false, false, false, false, false, false);
        logger.debug((Object)"Sec Conv with integrity tests");
        SecurityTestServiceAddressingLocator locator1 = new SecurityTestServiceAddressingLocator();
        testPort = locator1.getSecurityTestPortTypePort(testEPR);
        this.setGSISecConv(testPort, true, false);
        this.secureInvocations(testPort, true, true, false, true, false, false, false, true);
        logger.debug((Object)"Sec Conv with integrity and deleg tests");
        SecurityTestServiceAddressingLocator locator2 = new SecurityTestServiceAddressingLocator();
        testPort = locator2.getSecurityTestPortTypePort(testEPR);
        this.setGSISecConv(testPort, true, true);
        this.secureInvocations(testPort, true, true, false, true, false, false, false, true);
        logger.debug((Object)"Sec Conv with privacy and deleg tests");
        SecurityTestServiceAddressingLocator locator3 = new SecurityTestServiceAddressingLocator();
        testPort = locator3.getSecurityTestPortTypePort(testEPR);
        this.setGSISecConv(testPort, false, true);
        this.secureInvocations(testPort, true, false, true, true, false, false, false, true);
        logger.debug((Object)"Sec Msg tests");
        SecurityTestServiceAddressingLocator locator4 = new SecurityTestServiceAddressingLocator();
        testPort = locator4.getSecurityTestPortTypePort(testEPR);
        this.setGSISecMsg(testPort, true);
        this.secureInvocations(testPort, false, false, false, false, true, false, true, true);
        SecurityTestServiceAddressingLocator locator5 = new SecurityTestServiceAddressingLocator();
        testPort = locator4.getSecurityTestPortTypePort(testEPR);
        this.setGSISecMsg(testPort, false);
        this.secureInvocations(testPort, false, false, false, false, true, true, false, true);
    }

    public void resourceSecurityTest(EndpointReferenceType testEPR) throws Exception {
        SecurityTestServiceAddressingLocator locator = new SecurityTestServiceAddressingLocator();
        SecurityTestPortType testPort = locator.getSecurityTestPortTypePort(testEPR);
        CreateResourceResponse response = testPort.createResource(true);
        EndpointReferenceType res1EPR = response.getEndpointReference();
        SecurityTestPortType res1Port = locator.getSecurityTestPortTypePort(res1EPR);
        try {
            res1Port.alterSecurityDesc("GSISecureConv");
            SecureServiceAccessTest.fail((String)"Did not fail as expected");
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        this.setGSISecConv(res1Port, true, false);
        res1Port.alterSecurityDesc("GSISecureConv");
        res1Port.gsiSecMsgOnly(new GsiSecMsgOnly());
        res1Port.setAuthz("self");
        SecurityTestServiceAddressingLocator locator1 = new SecurityTestServiceAddressingLocator();
        SecurityTestPortType res1Port2 = locator1.getSecurityTestPortTypePort(res1EPR);
        this.setAnonymous(res1Port2);
        boolean expOccured = false;
        try {
            res1Port2.gsiSecConvOnly(new GsiSecConvOnly());
            SecureServiceAccessTest.fail((String)"Did not fail as expected");
        }
        catch (Exception exp) {
            expOccured = true;
        }
        SecureServiceAccessTest.assertTrue((boolean)expOccured);
        res1Port.setAuthz("none");
        logger.debug((Object)"Anonymous invocation");
        res1Port2.gsiSecConvOnly(new GsiSecConvOnly());
        response = testPort.createResource(true);
        EndpointReferenceType res2EPR = response.getEndpointReference();
        SecurityTestPortType res2Port = locator.getSecurityTestPortTypePort(res2EPR);
        this.setGSISecConv(res2Port, true, false);
        res2Port.alterSecurityDesc("GSISecureMsg");
        SecurityTestPortType res2Port1 = locator.getSecurityTestPortTypePort(res2EPR);
        this.setGSISecMsg(res2Port1, true);
        res2Port1.gsiSecConvIntegrity(new GsiSecConvIntegrity());
        SecurityTestServiceAddressingLocator locator2 = new SecurityTestServiceAddressingLocator();
        SecurityTestPortType port = locator2.getSecurityTestPortTypePort(testEPR);
        String replayWin = port.getSecurityProperty("replayWindow");
        SecureServiceAccessTest.assertTrue((replayWin != null ? 1 : 0) != 0);
        SecureServiceAccessTest.assertTrue((boolean)replayWin.equals("10000"));
        String replayFilter = port.getSecurityProperty("replayFilter");
        SecureServiceAccessTest.assertTrue((boolean)replayFilter.equals("randomValue"));
        res1Port.alterSecurityDesc(null);
        try {
            res1Port.gsiSecMsgOnly(new GsiSecMsgOnly());
            SecureServiceAccessTest.fail((String)"Did not fail as expected");
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        this.serviceSecurityTest(res1EPR);
    }

    private void secureInvocations(SecurityTestPortType testPort, boolean gsiSecConvDeleg, boolean gsiSecConvIntegrity, boolean gsiSecConvPrivacy, boolean gsiSecConvOnly, boolean gsiSecMsgOnly, boolean gsiSecMsgPrivacy, boolean gsiSecMsgIntegrity, boolean gsiSec) throws Exception {
        this.secureInvocations(testPort, true, gsiSecConvDeleg, gsiSecConvIntegrity, gsiSecConvPrivacy, gsiSecConvOnly, gsiSecMsgOnly, gsiSecMsgPrivacy, gsiSecMsgIntegrity, gsiSec);
    }

    private void secureInvocations(SecurityTestPortType testPort, boolean noAuth, boolean gsiSecConvDeleg, boolean gsiSecConvIntegrity, boolean gsiSecConvPrivacy, boolean gsiSecConvOnly, boolean gsiSecMsgOnly, boolean gsiSecMsgPrivacy, boolean gsiSecMsgIntegrity, boolean gsiSec) throws Exception {
        logger.debug((Object)"No auth");
        boolean exp = true;
        try {
            testPort.noAuth(null);
        }
        catch (Exception e) {
            logger.error((Object)e);
            exp = false;
        }
        SecureServiceAccessTest.assertTrue((exp == noAuth ? 1 : 0) != 0);
        logger.debug((Object)"GSI Sec Conv Integrity");
        exp = true;
        try {
            testPort.gsiSecConvIntegrity(new GsiSecConvIntegrity());
        }
        catch (Exception e) {
            logger.error((Object)e);
            exp = false;
        }
        SecureServiceAccessTest.assertTrue((exp == gsiSecConvIntegrity ? 1 : 0) != 0);
        logger.debug((Object)"GSI Sec Conv Privacy");
        exp = true;
        try {
            testPort.gsiSecConvPrivacy(new GsiSecConvPrivacy());
        }
        catch (Exception e) {
            logger.error((Object)e);
            exp = false;
        }
        SecureServiceAccessTest.assertTrue((exp == gsiSecConvPrivacy ? 1 : 0) != 0);
        logger.debug((Object)"GSI Sec Conv Delegation");
        exp = true;
        try {
            testPort.gsiSecConvDeleg(new GsiSecConvDeleg());
        }
        catch (Exception e) {
            exp = false;
        }
        SecureServiceAccessTest.assertTrue((exp == gsiSecConvDeleg ? 1 : 0) != 0);
        logger.debug((Object)"GSI Sec Conv Only");
        exp = true;
        try {
            testPort.gsiSecConvOnly(new GsiSecConvOnly());
        }
        catch (Exception e) {
            logger.error((Object)e);
            exp = false;
        }
        SecureServiceAccessTest.assertTrue((exp == gsiSecConvOnly ? 1 : 0) != 0);
        logger.debug((Object)"GSI Sec Msg");
        exp = true;
        try {
            testPort.gsiSecMsgOnly(new GsiSecMsgOnly());
        }
        catch (Exception e) {
            logger.error((Object)e);
            exp = false;
        }
        SecureServiceAccessTest.assertTrue((exp == gsiSecMsgOnly ? 1 : 0) != 0);
        logger.debug((Object)"GSI Sec Msg privacy");
        exp = true;
        try {
            testPort.gsiSecMsgPrivacy(new GsiSecMsgPrivacy());
        }
        catch (Exception e) {
            logger.error((Object)e);
            exp = false;
        }
        SecureServiceAccessTest.assertTrue((exp == gsiSecMsgPrivacy ? 1 : 0) != 0);
        logger.debug((Object)"GSI Sec Msg integrity");
        exp = true;
        try {
            testPort.gsiSecMsgIntegrity(new GsiSecMsgIntegrity());
        }
        catch (Exception e) {
            logger.error((Object)e);
            exp = false;
        }
        SecureServiceAccessTest.assertTrue((exp == gsiSecMsgIntegrity ? 1 : 0) != 0);
        logger.debug((Object)"GSI Security");
        exp = true;
        try {
            testPort.gsiSec(new GsiSec());
        }
        catch (Exception e) {
            logger.error((Object)e);
            exp = false;
        }
        SecureServiceAccessTest.assertTrue((exp == gsiSec ? 1 : 0) != 0);
    }

    private void setGSISecConv(SecurityTestPortType testPort, boolean sig, boolean deleg) {
        if (sig && deleg) {
            if (this.authz instanceof HostAuthorization) {
                ((Stub)testPort)._setProperty("clientDescriptorFile", (Object)HOST_CLIENT_DESC_FILE);
            } else {
                ((Stub)testPort)._setProperty("clientDescriptorFile", (Object)CLIENT_DESC_FILE);
            }
            return;
        }
        if (sig && !deleg) {
            ClientSecurityDescriptor desc = new ClientSecurityDescriptor();
            desc.setGSISecureConv(GSIConstants.SIGNATURE);
            desc.setAuthz(this.authz);
            ((Stub)testPort)._setProperty("clientDescriptor", (Object)desc);
            return;
        }
        if (sig) {
            ((Stub)testPort)._setProperty("org.globus.security.secConv.msg.type", (Object)GSIConstants.SIGNATURE);
        } else {
            ((Stub)testPort)._setProperty("org.globus.security.secConv.msg.type", (Object)GSIConstants.ENCRYPTION);
        }
        if (deleg) {
            ((Stub)testPort)._setProperty("org.globus.gsi.mode", (Object)"gsifull");
        } else {
            ((Stub)testPort)._setProperty("org.globus.gsi.mode", (Object)"gsi");
        }
        ((Stub)testPort)._setProperty("org.globus.security.authorization", (Object)this.authz);
    }

    private void setAnonymous(SecurityTestPortType testPort) {
        ClientSecurityDescriptor desc = new ClientSecurityDescriptor();
        desc.setGSISecureConv(GSIConstants.SIGNATURE);
        desc.setAnonymous();
        desc.setAuthz((Authorization)new NoAuthorization());
        ((Stub)testPort)._setProperty("clientDescriptor", (Object)desc);
    }

    private void setGSISecMsg(SecurityTestPortType testPort, boolean sig) throws Exception {
        if (sig) {
            ((Stub)testPort)._setProperty("org.globus.security.secMsg.msg.type", (Object)GSIConstants.SIGNATURE);
        } else {
            ((Stub)testPort)._setProperty("org.globus.security.secMsg.msg.type", (Object)GSIConstants.ENCRYPTION);
            if (this.authz instanceof HostAuthorization) {
                ((Stub)testPort)._setProperty("callerSubject", (Object)TestConstants.getPeerSubjectForClient(false));
            } else {
                ((Stub)testPort)._setProperty("callerSubject", (Object)TestConstants.getPeerSubjectForClient(true));
            }
        }
        ((Stub)testPort)._setProperty("org.globus.security.authorization", (Object)this.authz);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

