/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.properties;

import java.io.IOException;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.ser.SimpleSerializerFactory;
import org.apache.axis.message.MessageElement;
import org.apache.axis.types.URI;
import org.globus.wsrf.WSRFConstants;
import org.globus.wsrf.encoding.DialectDependentSerializer;
import org.globus.wsrf.impl.TestHome;
import org.globus.wsrf.impl.TestResource;
import org.globus.wsrf.impl.properties.PropertiesTestCase;
import org.globus.wsrf.impl.properties.TestExpressionEvaluator;
import org.globus.wsrf.tests.basic.TestPortType;
import org.globus.wsrf.utils.AnyHelper;
import org.oasis.wsrf.properties.InvalidQueryExpressionFaultType;
import org.oasis.wsrf.properties.QueryEvaluationErrorFaultType;
import org.oasis.wsrf.properties.QueryExpressionType;
import org.oasis.wsrf.properties.QueryResourcePropertiesResponse;
import org.oasis.wsrf.properties.QueryResourceProperties_Element;
import org.oasis.wsrf.properties.ResourceUnknownFaultType;
import org.oasis.wsrf.properties.UnknownQueryExpressionDialectFaultType;

public class QueryResourcePropertiesTests
extends PropertiesTestCase {
    private static final String SIMPLE_QUERY = "boolean(/*/*[namespace-uri()='http://docs.oasis-open.org/wsrf/2004/06/wsrf-WS-ResourceLifetime-1.2-draft-01.xsd' and local-name()='TerminationTime'])";
    private static final String COMPLEX_QUERY = "/";
    static /* synthetic */ Class class$org$oasis$wsrf$properties$QueryExpressionType;
    static /* synthetic */ Class class$java$lang$String;

    public QueryResourcePropertiesTests(String name) {
        super(name);
    }

    private QueryExpressionType createQueryExpression(String dialect, String queryString) throws IOException {
        QueryExpressionType query = new QueryExpressionType();
        query.setDialect(dialect);
        if (queryString != null) {
            query.setValue((Object)queryString);
        }
        return query;
    }

    public void testUnknownResource() throws Exception {
        TestPortType port = this.locator.getTestPortTypePort(this.createEPR(TestHome.BAD_KEY));
        QueryResourceProperties_Element queryRequest = new QueryResourceProperties_Element();
        queryRequest.setQueryExpression(this.createQueryExpression("http://www.w3.org/TR/1999/REC-xpath-19991116", COMPLEX_QUERY));
        try {
            QueryResourcePropertiesResponse queryResponse = port.queryResourceProperties(queryRequest);
            QueryResourcePropertiesTests.fail((String)"Did not throw exception");
        }
        catch (ResourceUnknownFaultType resourceUnknownFaultType) {
            // empty catch block
        }
    }

    public void testUnknownQueryExpressionDialect() throws Exception {
        TestPortType port = this.locator.getTestPortTypePort(this.getServiceAddress());
        port = this.locator.getTestPortTypePort(this.createResource(port));
        QueryResourceProperties_Element queryRequest = new QueryResourceProperties_Element();
        String dialect = "http://foobar";
        queryRequest.setQueryExpression(this.createQueryExpression(dialect, COMPLEX_QUERY));
        TypeMappingRegistry tmr = this.locator.getTypeMappingRegistry();
        TypeMapping tm = tmr.getTypeMapping("");
        DialectDependentSerializer sf = (DialectDependentSerializer)tm.getSerializer(class$org$oasis$wsrf$properties$QueryExpressionType == null ? (class$org$oasis$wsrf$properties$QueryExpressionType = QueryResourcePropertiesTests.class$("org.oasis.wsrf.properties.QueryExpressionType")) : class$org$oasis$wsrf$properties$QueryExpressionType, null).getSerializerAs("");
        sf.registerSerializerFactory(new URI(dialect), (SerializerFactory)new SimpleSerializerFactory(class$java$lang$String == null ? (class$java$lang$String = QueryResourcePropertiesTests.class$("java.lang.String")) : class$java$lang$String, Constants.XSD_STRING));
        try {
            QueryResourcePropertiesResponse queryResponse = port.queryResourceProperties(queryRequest);
            QueryResourcePropertiesTests.fail((String)"Did not throw exception");
        }
        catch (UnknownQueryExpressionDialectFaultType e) {
            // empty catch block
        }
    }

    public void testQueryEvaluationError() throws Exception {
        TestPortType port = this.locator.getTestPortTypePort(this.getServiceAddress());
        port = this.locator.getTestPortTypePort(this.createResource(port));
        QueryResourceProperties_Element queryRequest = new QueryResourceProperties_Element();
        queryRequest.setQueryExpression(this.createQueryExpression("http://www.w3.org/TR/1999/REC-xpath-19991116", "\\"));
        try {
            QueryResourcePropertiesResponse queryResponse = port.queryResourceProperties(queryRequest);
            QueryResourcePropertiesTests.fail((String)"Did not throw exception as expected");
        }
        catch (QueryEvaluationErrorFaultType queryEvaluationErrorFaultType) {
            // empty catch block
        }
    }

    public void testInvalidQueryExpression() throws Exception {
        TestPortType port = this.locator.getTestPortTypePort(this.getServiceAddress());
        port = this.locator.getTestPortTypePort(this.createResource(port));
        QueryResourcePropertiesResponse queryResponse = null;
        QueryResourceProperties_Element queryRequest = new QueryResourceProperties_Element();
        queryRequest.setQueryExpression(this.createQueryExpression("http://www.w3.org/TR/1999/REC-xpath-19991116", ""));
        try {
            queryResponse = port.queryResourceProperties(queryRequest);
            QueryResourcePropertiesTests.fail((String)"Did not throw exception as expected");
        }
        catch (InvalidQueryExpressionFaultType e) {
            // empty catch block
        }
        queryRequest.setQueryExpression(this.createQueryExpression("http://www.w3.org/TR/1999/REC-xpath-19991116", null));
        try {
            queryResponse = port.queryResourceProperties(queryRequest);
            QueryResourcePropertiesTests.fail((String)"Did not throw exception as expected");
        }
        catch (InvalidQueryExpressionFaultType e) {
            // empty catch block
        }
    }

    public void testOtherErrors() throws Exception {
        TestPortType port = this.locator.getTestPortTypePort(this.getServiceAddress());
        port = this.locator.getTestPortTypePort(this.createResource(port));
        QueryResourcePropertiesResponse queryResponse = null;
        QueryResourceProperties_Element queryRequest = null;
        try {
            queryResponse = port.queryResourceProperties(queryRequest);
            QueryResourcePropertiesTests.fail((String)"Did not throw exception as expected");
        }
        catch (AxisFault e) {
            // empty catch block
        }
        queryRequest = new QueryResourceProperties_Element();
        try {
            queryResponse = port.queryResourceProperties(queryRequest);
            QueryResourcePropertiesTests.fail((String)"Did not throw exception as expected");
        }
        catch (AxisFault e) {
            // empty catch block
        }
        queryRequest.setQueryExpression(new QueryExpressionType());
        try {
            queryResponse = port.queryResourceProperties(queryRequest);
            QueryResourcePropertiesTests.fail((String)"Did not throw exception as expected");
        }
        catch (AxisFault e) {
            // empty catch block
        }
    }

    public void testSimpleContentQuery() throws Exception {
        TestPortType port = this.locator.getTestPortTypePort(this.getServiceAddress());
        port = this.locator.getTestPortTypePort(this.createResource(port));
        QueryResourceProperties_Element queryRequest = new QueryResourceProperties_Element();
        queryRequest.setQueryExpression(this.createQueryExpression("http://www.w3.org/TR/1999/REC-xpath-19991116", SIMPLE_QUERY));
        QueryResourcePropertiesResponse queryResponse = port.queryResourceProperties(queryRequest);
        MessageElement[] any = queryResponse.get_any();
        QueryResourcePropertiesTests.assertTrue((any != null ? 1 : 0) != 0);
        QueryResourcePropertiesTests.assertTrue((any.length > 0 ? 1 : 0) != 0);
        QueryResourcePropertiesTests.assertEquals((short)3, (short)any[0].getNodeType());
        QueryResourcePropertiesTests.assertEquals((String)"true", (String)any[0].getNodeValue());
    }

    public void testComplexContentQuery() throws Exception {
        TestPortType port = this.locator.getTestPortTypePort(this.getServiceAddress());
        port = this.locator.getTestPortTypePort(this.createResource(port));
        QueryResourceProperties_Element queryRequest = new QueryResourceProperties_Element();
        queryRequest.setQueryExpression(this.createQueryExpression("http://www.w3.org/TR/1999/REC-xpath-19991116", COMPLEX_QUERY));
        QueryResourcePropertiesResponse queryResponse = port.queryResourceProperties(queryRequest);
        MessageElement[] any = queryResponse.get_any();
        QueryResourcePropertiesTests.assertTrue((any != null ? 1 : 0) != 0);
        QueryResourcePropertiesTests.assertTrue((any.length > 0 ? 1 : 0) != 0);
        System.out.println(AnyHelper.toSingleString((MessageElement[])any));
        QName[] propNames = new QName[]{TestResource.VALUE_RP, WSRFConstants.CURRENT_TIME};
        boolean found = false;
        for (int i = 0; i < propNames.length; ++i) {
            found = false;
            Iterator iter = any[0].getChildElements();
            while (iter.hasNext()) {
                if (!propNames[i].equals(((MessageElement)iter.next()).getQName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            QueryResourcePropertiesTests.fail((String)("Did not return expected RP: " + propNames[i]));
        }
    }

    public void testCustomQueryDialect() throws Exception {
        TestPortType port = this.locator.getTestPortTypePort(this.getServiceAddress());
        port = this.locator.getTestPortTypePort(this.createResource(port));
        QueryResourceProperties_Element queryRequest = new QueryResourceProperties_Element();
        queryRequest.setQueryExpression(this.createQueryExpression(TestExpressionEvaluator.DIALECTS[0], "testExpression"));
        QueryResourcePropertiesResponse queryResponse = port.queryResourceProperties(queryRequest);
        MessageElement[] any = queryResponse.get_any();
        QueryResourcePropertiesTests.assertTrue((any != null ? 1 : 0) != 0);
        QueryResourcePropertiesTests.assertTrue((any.length > 0 ? 1 : 0) != 0);
        QueryResourcePropertiesTests.assertEquals((short)3, (short)any[0].getNodeType());
        QueryResourcePropertiesTests.assertEquals((String)"hello", (String)any[0].getNodeValue());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

