/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.properties;

import java.util.Calendar;
import javax.xml.namespace.QName;
import org.apache.axis.message.MessageElement;
import org.globus.wsrf.WSRFConstants;
import org.globus.wsrf.impl.TestHome;
import org.globus.wsrf.impl.properties.PropertiesTestCase;
import org.globus.wsrf.tests.basic.TestPortType;
import org.oasis.wsrf.lifetime.SetTerminationTime;
import org.oasis.wsrf.lifetime.SetTerminationTimeResponse;
import org.oasis.wsrf.properties.GetMultipleResourcePropertiesResponse;
import org.oasis.wsrf.properties.GetMultipleResourceProperties_Element;
import org.oasis.wsrf.properties.InvalidResourcePropertyQNameFaultType;
import org.oasis.wsrf.properties.ResourceUnknownFaultType;

public class GetMultipleResourcePropertiesTests
extends PropertiesTestCase {
    private static final QName[] PROP_NAMES = new QName[]{WSRFConstants.TERMINATION_TIME, WSRFConstants.CURRENT_TIME};

    public GetMultipleResourcePropertiesTests(String name) {
        super(name);
    }

    public void testUnknownResource() throws Exception {
        TestPortType port = this.locator.getTestPortTypePort(this.createEPR(TestHome.BAD_KEY));
        GetMultipleResourceProperties_Element request = new GetMultipleResourceProperties_Element();
        request.setResourceProperty(PROP_NAMES);
        try {
            GetMultipleResourcePropertiesResponse reponse = port.getMultipleResourceProperties(request);
            GetMultipleResourcePropertiesTests.fail((String)"Did not throw exception");
        }
        catch (ResourceUnknownFaultType resourceUnknownFaultType) {
            // empty catch block
        }
    }

    public void testGetMultipleResourceProperties() throws Exception {
        TestPortType port = this.locator.getTestPortTypePort(this.getServiceAddress());
        port = this.locator.getTestPortTypePort(this.createResource(port));
        GetMultipleResourceProperties_Element propRequest = null;
        GetMultipleResourcePropertiesResponse propResponse = null;
        propRequest = new GetMultipleResourceProperties_Element();
        propRequest.setResourceProperty(PROP_NAMES);
        propResponse = port.getMultipleResourceProperties(propRequest);
        MessageElement[] any = null;
        any = propResponse.get_any();
        GetMultipleResourcePropertiesTests.assertTrue((any != null ? 1 : 0) != 0);
        GetMultipleResourcePropertiesTests.assertEquals((int)2, (int)any.length);
        GetMultipleResourcePropertiesTests.assertEquals((Object)WSRFConstants.TERMINATION_TIME, (Object)any[0].getQName());
        GetMultipleResourcePropertiesTests.assertEquals((String)"true", (String)any[0].getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "nil"));
        GetMultipleResourcePropertiesTests.assertEquals((Object)WSRFConstants.CURRENT_TIME, (Object)any[1].getQName());
        Calendar termTime = Calendar.getInstance();
        termTime.add(13, 30);
        SetTerminationTime timeRequest = new SetTerminationTime();
        timeRequest.setRequestedTerminationTime(termTime);
        SetTerminationTimeResponse timeResponse = port.setTerminationTime(timeRequest);
        propResponse = port.getMultipleResourceProperties(propRequest);
        any = propResponse.get_any();
        GetMultipleResourcePropertiesTests.assertTrue((any != null ? 1 : 0) != 0);
        GetMultipleResourcePropertiesTests.assertEquals((int)2, (int)any.length);
        boolean found = false;
        for (int i = 0; i < PROP_NAMES.length; ++i) {
            found = false;
            for (int j = 0; j < any.length; ++j) {
                if (!PROP_NAMES[i].equals(any[j].getQName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            GetMultipleResourcePropertiesTests.fail((String)"Did not return expected RP");
        }
    }

    public void testGetUnknownResourceProperties() throws Exception {
        TestPortType port = this.locator.getTestPortTypePort(this.getServiceAddress());
        port = this.locator.getTestPortTypePort(this.createResource(port));
        GetMultipleResourcePropertiesResponse propResponse = null;
        GetMultipleResourceProperties_Element propRequest = null;
        try {
            propResponse = port.getMultipleResourceProperties(propRequest);
            GetMultipleResourcePropertiesTests.fail((String)"Did not throw exception");
        }
        catch (InvalidResourcePropertyQNameFaultType e) {
            // empty catch block
        }
        propRequest = new GetMultipleResourceProperties_Element();
        try {
            propResponse = port.getMultipleResourceProperties(propRequest);
            GetMultipleResourcePropertiesTests.fail((String)"Did not throw exception");
        }
        catch (InvalidResourcePropertyQNameFaultType e) {
            // empty catch block
        }
        propRequest.setResourceProperty(new QName[0]);
        try {
            propResponse = port.getMultipleResourceProperties(propRequest);
            GetMultipleResourcePropertiesTests.fail((String)"Did not throw exception");
        }
        catch (InvalidResourcePropertyQNameFaultType e) {
            // empty catch block
        }
        QName badRP = new QName("http://foo", "bar");
        propRequest.setResourceProperty(new QName[]{badRP});
        try {
            propResponse = port.getMultipleResourceProperties(propRequest);
            GetMultipleResourcePropertiesTests.fail((String)"Did not throw exception");
        }
        catch (InvalidResourcePropertyQNameFaultType e) {
            // empty catch block
        }
        propRequest.setResourceProperty(new QName[]{badRP, WSRFConstants.CURRENT_TIME});
        try {
            propResponse = port.getMultipleResourceProperties(propRequest);
            GetMultipleResourcePropertiesTests.fail((String)"Did not throw exception");
        }
        catch (InvalidResourcePropertyQNameFaultType e) {
            // empty catch block
        }
    }
}

