/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.notification;

import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.globus.wsrf.NotificationConsumerManager;
import org.globus.wsrf.NotifyCallback;
import org.globus.wsrf.impl.notification.NotificationTestCase;
import org.globus.wsrf.impl.notification.NotificationTestService;
import org.globus.wsrf.impl.notification.TestNotifyCallback;
import org.globus.wsrf.test.GridTestSuite;
import org.oasis.wsn.ResourceUnknownFaultType;
import org.oasis.wsn.Subscribe;
import org.oasis.wsn.SubscribeResponse;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsn.TopicNotSupportedFaultType;
import org.oasis.wsn.TopicPathDialectUnknownFaultType;

public class SubscribeTests
extends NotificationTestCase {
    public SubscribeTests(String name) {
        super(name);
    }

    public void testSubscribe() throws Exception {
        TestNotifyCallback callback = new TestNotifyCallback();
        int expectedCount = 1;
        NotificationConsumerManager consumer = NotificationConsumerManager.getInstance();
        consumer.startListening();
        EndpointReferenceType consumerEPR = consumer.createNotificationConsumer((NotifyCallback)callback);
        Subscribe request = new Subscribe();
        request.setConsumerReference(consumerEPR);
        TopicExpressionType topicPath = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (Object)NotificationTestService.TEST_TOPIC);
        request.setTopicExpression(topicPath);
        SubscribeResponse response = this.port.subscribe(request);
        this.port.generateNotification(NotificationTestService.TEST_TOPIC);
        SubscribeTests.assertTrue((boolean)callback.waitForCount(expectedCount, GridTestSuite.timeout));
        SubscribeTests.assertEquals((int)expectedCount, (int)callback.getNotifyCount());
        super.destroySubscription(response.getSubscriptionReference());
    }

    public void testSubscribeResourceUnknown() throws Exception {
        ResourceUnknownFaultType fault = null;
        Subscribe request = new Subscribe();
        request.setConsumerReference(this.badEPR);
        TopicExpressionType topicPath = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (Object)NotificationTestService.TEST_TOPIC);
        request.setTopicExpression(topicPath);
        try {
            this.badPort.subscribe(request);
        }
        catch (ResourceUnknownFaultType e) {
            fault = e;
        }
        SubscribeTests.assertTrue((fault != null ? 1 : 0) != 0);
    }

    public void testSubscribeTopicPathDialectUnknown() throws Exception {
        TopicPathDialectUnknownFaultType fault = null;
        Subscribe request = new Subscribe();
        request.setConsumerReference(this.testServiceEPR);
        TopicExpressionType topicPath = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Concrete", (Object)NotificationTestService.TEST_TOPIC);
        request.setTopicExpression(topicPath);
        try {
            this.port.subscribe(request);
        }
        catch (TopicPathDialectUnknownFaultType e) {
            fault = e;
        }
        SubscribeTests.assertTrue((fault != null ? 1 : 0) != 0);
    }

    public void testSubscribeUnsupportedTopic() throws Exception {
        TopicNotSupportedFaultType fault = null;
        Subscribe request = new Subscribe();
        request.setConsumerReference(this.testServiceEPR);
        TopicExpressionType topicPath = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (Object)new QName("foo"));
        request.setTopicExpression(topicPath);
        try {
            this.port.subscribe(request);
        }
        catch (TopicNotSupportedFaultType e) {
            fault = e;
        }
        SubscribeTests.assertTrue((fault != null ? 1 : 0) != 0);
    }
}

