/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.notification;

import java.util.Calendar;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.globus.wsrf.NotificationConsumerManager;
import org.globus.wsrf.NotifyCallback;
import org.globus.wsrf.core.notification.PersistenceTestSubscriptionManager;
import org.globus.wsrf.core.notification.service.PersistenceTestSubscriptionManagerServiceAddressingLocator;
import org.globus.wsrf.impl.notification.NotificationTestCase;
import org.globus.wsrf.impl.notification.NotificationTestService;
import org.globus.wsrf.impl.notification.TestNotifyCallback;
import org.globus.wsrf.test.GridTestSuite;
import org.globus.wsrf.tests.invalidate.InvalidateRequest;
import org.oasis.wsn.Subscribe;
import org.oasis.wsn.SubscribeResponse;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsrf.lifetime.Destroy;
import org.oasis.wsrf.lifetime.ResourceUnknownFaultType;

public class PersistentSubscriptionTests
extends NotificationTestCase {
    private PersistenceTestSubscriptionManagerServiceAddressingLocator managerLocator = new PersistenceTestSubscriptionManagerServiceAddressingLocator();

    public PersistentSubscriptionTests(String name) {
        super(name);
    }

    public void testSubscriptionResourcePersistence() throws Exception {
        TestNotifyCallback callback = new TestNotifyCallback();
        int expectedCount = 1;
        NotificationConsumerManager consumer = NotificationConsumerManager.getInstance();
        consumer.startListening();
        EndpointReferenceType consumerEPR = consumer.createNotificationConsumer((NotifyCallback)callback);
        Subscribe request = new Subscribe();
        request.setConsumerReference(consumerEPR);
        TopicExpressionType topicPath = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (Object)NotificationTestService.TEST_TOPIC);
        request.setTopicExpression(topicPath);
        SubscribeResponse response = this.port.subscribe(request);
        PersistenceTestSubscriptionManager manager = this.managerLocator.getPersistenceTestSubscriptionManagerPort(response.getSubscriptionReference());
        manager.invalidate(new InvalidateRequest());
        this.port.generateNotification(NotificationTestService.TEST_TOPIC);
        PersistentSubscriptionTests.assertTrue((boolean)callback.waitForCount(expectedCount, GridTestSuite.timeout));
        PersistentSubscriptionTests.assertEquals((int)expectedCount, (int)callback.getNotifyCount());
        manager.destroy(new Destroy());
    }

    public void testSubscriptionPersistence() throws Exception {
        TestNotifyCallback callback = new TestNotifyCallback();
        int expectedCount = 1;
        NotificationConsumerManager consumer = NotificationConsumerManager.getInstance();
        consumer.startListening();
        EndpointReferenceType consumerEPR = consumer.createNotificationConsumer((NotifyCallback)callback);
        Subscribe request = new Subscribe();
        request.setConsumerReference(consumerEPR);
        TopicExpressionType topicPath = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (Object)NotificationTestService.TEST_TOPIC);
        request.setTopicExpression(topicPath);
        SubscribeResponse response = this.port.subscribe(request);
        PersistenceTestSubscriptionManager manager = this.managerLocator.getPersistenceTestSubscriptionManagerPort(response.getSubscriptionReference());
        manager.invalidate(new InvalidateRequest());
        this.port.invalidate(new InvalidateRequest());
        this.port.generateNotification(NotificationTestService.TEST_TOPIC);
        PersistentSubscriptionTests.assertTrue((boolean)callback.waitForCount(expectedCount, GridTestSuite.timeout));
        PersistentSubscriptionTests.assertEquals((int)expectedCount, (int)callback.getNotifyCount());
        manager.destroy(new Destroy());
    }

    public void testSubscriptionPersistenceTimeout() throws Exception {
        TestNotifyCallback callback = new TestNotifyCallback();
        boolean expectedCount = true;
        NotificationConsumerManager consumer = NotificationConsumerManager.getInstance();
        consumer.startListening();
        EndpointReferenceType consumerEPR = consumer.createNotificationConsumer((NotifyCallback)callback);
        Subscribe request = new Subscribe();
        request.setConsumerReference(consumerEPR);
        Calendar termTime = Calendar.getInstance();
        termTime.add(13, 30);
        request.setInitialTerminationTime(termTime);
        TopicExpressionType topicPath = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (Object)NotificationTestService.TEST_TOPIC);
        request.setTopicExpression(topicPath);
        SubscribeResponse response = this.port.subscribe(request);
        PersistenceTestSubscriptionManager manager = this.managerLocator.getPersistenceTestSubscriptionManagerPort(response.getSubscriptionReference());
        manager.invalidate(new InvalidateRequest());
        Thread.sleep(60000L);
        try {
            manager.destroy(new Destroy());
        }
        catch (ResourceUnknownFaultType e) {
            // empty catch block
        }
    }

    public void testSubscriptionListenerPersistence() throws Exception {
        TestNotifyCallback callback = new TestNotifyCallback();
        int expectedCount = 1;
        NotificationConsumerManager consumer = NotificationConsumerManager.getInstance();
        consumer.startListening();
        EndpointReferenceType consumerEPR = consumer.createNotificationConsumer((NotifyCallback)callback);
        Subscribe request = new Subscribe();
        request.setConsumerReference(consumerEPR);
        TopicExpressionType topicPath = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (Object)NotificationTestService.TEST_TOPIC);
        request.setTopicExpression(topicPath);
        SubscribeResponse response = this.port.subscribe(request);
        PersistenceTestSubscriptionManager manager = this.managerLocator.getPersistenceTestSubscriptionManagerPort(response.getSubscriptionReference());
        this.port.invalidate(new InvalidateRequest());
        this.port.generateNotification(NotificationTestService.TEST_TOPIC);
        PersistentSubscriptionTests.assertTrue((boolean)callback.waitForCount(expectedCount, GridTestSuite.timeout));
        PersistentSubscriptionTests.assertEquals((int)expectedCount, (int)callback.getNotifyCount());
        manager.destroy(new Destroy());
    }
}

