/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.notification;

import javax.xml.rpc.Stub;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.globus.wsrf.NotificationConsumerManager;
import org.globus.wsrf.NotifyCallback;
import org.globus.wsrf.core.notification.SubscriptionManager;
import org.globus.wsrf.core.notification.service.SubscriptionManagerServiceAddressingLocator;
import org.globus.wsrf.impl.notification.NotificationTestService;
import org.globus.wsrf.impl.notification.TestNotifyCallback;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityDescriptor;
import org.globus.wsrf.test.GridTestSuite;
import org.globus.wsrf.tests.notification.NotificationTestPortType;
import org.globus.wsrf.tests.notification.service.NotificationTestServiceAddressingLocator;
import org.oasis.wsn.Subscribe;
import org.oasis.wsn.SubscribeResponse;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsrf.lifetime.Destroy;

public class NotifyThread
extends Thread {
    SubscriptionManagerServiceAddressingLocator managerLocator = new SubscriptionManagerServiceAddressingLocator();
    EndpointReferenceType epr;
    NotificationConsumerManager consumer;
    ClientSecurityDescriptor secDesc;
    Object lock;
    Throwable exception;
    boolean subscribed = false;

    public NotifyThread(EndpointReferenceType epr, NotificationConsumerManager consumer, Object lock, ClientSecurityDescriptor secDesc) {
        this.consumer = consumer;
        this.lock = lock;
        this.secDesc = secDesc;
        this.epr = epr;
    }

    public boolean isSubscribed() {
        return this.subscribed;
    }

    public Throwable getException() {
        return this.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            TestNotifyCallback callback = new TestNotifyCallback();
            EndpointReferenceType consumerEPR = this.consumer.createNotificationConsumer((NotifyCallback)callback);
            Subscribe request = new Subscribe();
            request.setConsumerReference(consumerEPR);
            TopicExpressionType topicPath = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (Object)NotificationTestService.TEST_TOPIC);
            request.setTopicExpression(topicPath);
            NotificationTestServiceAddressingLocator locator = new NotificationTestServiceAddressingLocator();
            NotificationTestPortType port = locator.getNotificationTestPortTypePort(this.epr);
            if (this.secDesc != null) {
                ((Stub)port)._setProperty("clientDescriptor", (Object)this.secDesc);
            }
            SubscribeResponse response = port.subscribe(request);
            this.subscribed = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.wait();
            }
            int expectedCount = 1;
            if (!callback.waitForCount(expectedCount, GridTestSuite.timeout)) {
                throw new Exception("Timeout waiting for notifcations");
            }
            if (expectedCount != callback.getNotifyCount()) {
                throw new Exception("Expected " + expectedCount + " notifications but received " + callback.getNotifyCount());
            }
            SubscriptionManager manager = this.managerLocator.getSubscriptionManagerPort(response.getSubscriptionReference());
            if (this.secDesc != null) {
                ((Stub)manager)._setProperty("clientDescriptor", (Object)this.secDesc);
            }
            manager.destroy(new Destroy());
        }
        catch (Throwable e) {
            this.exception = e;
        }
    }
}

