/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.notification;

import java.rmi.RemoteException;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.globus.wsrf.NotificationConsumerManager;
import org.globus.wsrf.NotifyCallback;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.Topic;
import org.globus.wsrf.TopicList;
import org.globus.wsrf.TopicListAccessor;
import org.globus.wsrf.container.ContainerException;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.core.notification.SubscriptionManager;
import org.globus.wsrf.core.notification.service.SubscriptionManagerServiceAddressingLocator;
import org.globus.wsrf.impl.notification.NotificationTestHome;
import org.globus.wsrf.impl.notification.NotificationTestResource;
import org.globus.wsrf.impl.notification.ServerNotificationConsumerManager;
import org.globus.wsrf.impl.notification.TestNotifyCallback;
import org.globus.wsrf.test.GridTestSuite;
import org.globus.wsrf.tests.notification.GenerateNotificationResponse;
import org.globus.wsrf.tests.notification.NotificationTestPortType;
import org.globus.wsrf.tests.notification.SelfSubscribeRequest;
import org.globus.wsrf.tests.notification.SelfSubscribeResponse;
import org.globus.wsrf.tests.notification.service.NotificationTestServiceAddressingLocator;
import org.globus.wsrf.utils.AddressingUtils;
import org.globus.wsrf.utils.XmlUtils;
import org.oasis.wsn.ResourceUnknownFaultType;
import org.oasis.wsn.Subscribe;
import org.oasis.wsn.SubscribeResponse;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsrf.lifetime.Destroy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NotificationTestService {
    public static final String SERVICE_PATH = "NotificationTestService";
    public static final String TEST_NS = "http://wsrf.globus.org/tests/notification";
    public static final QName RP_SET = new QName("http://wsrf.globus.org/tests/notification", "NotificationTestRP");
    public static final QName TEST_TOPIC = new QName("http://wsrf.globus.org/tests/notification", "TestTopic");
    public static final QName EMPTY_TOPIC = new QName("http://wsrf.globus.org/tests/notification", "EmptyTopic");
    public static final QName THIRD_TOPIC = new QName("http://wsrf.globus.org/tests/notification", "ThirdTopic");
    public static final QName FOURTH_TOPIC = new QName("http://wsrf.globus.org/tests/notification", "FourthTopic");
    public static final QName JOB_STATUS_TOPIC_RP = new QName("http://wsrf.globus.org/tests/notification", "JobStatusRP");
    public static final QName AUTO_NOTIFY_TOPIC_RP = new QName("http://wsrf.globus.org/tests/notification", "AutoNotifyTopicRP");
    public static final QName SEND_OLD_TOPIC_RP = new QName("http://wsrf.globus.org/tests/notification", "SendOldTopicRP");
    public static final String JOB_STATUS_ACTIVE = "Active";
    public static final String JOB_STATUS_DONE = "Done";

    public GenerateNotificationResponse generateNotification(QName request) throws RemoteException, ResourceUnknownFaultType {
        Resource resource = null;
        try {
            resource = ResourceContext.getResourceContext().getResource();
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RemoteException("", e);
        }
        NotificationTestResource r = (NotificationTestResource)resource;
        TopicList topicList = ((TopicListAccessor)resource).getTopicList();
        if (request.getNamespaceURI().equals("")) {
            request = new QName(TEST_NS, request.getLocalPart());
        }
        LinkedList<QName> topicPath = new LinkedList<QName>();
        topicPath.add(request);
        Topic topic = topicList.getTopic(topicPath);
        try {
            Document document = XmlUtils.newDocument();
            if (topic.equals(r.getJobStatusTopic())) {
                r.getJobStatus().setJobState(JOB_STATUS_DONE);
            }
            Element message = document.createElementNS(TEST_NS, "test:TestNotification");
            topic.notify((Object)message);
        }
        catch (Exception e) {
            throw new RemoteException("", e);
        }
        return new GenerateNotificationResponse();
    }

    public SelfSubscribeResponse selfSubscribe(SelfSubscribeRequest req) throws RemoteException {
        NotificationConsumerManager consumer = NotificationConsumerManager.getInstance();
        if (!(consumer instanceof ServerNotificationConsumerManager)) {
            throw new RemoteException("Invalid notification consumer manager");
        }
        try {
            consumer.startListening();
        }
        catch (Exception e) {
            throw new RemoteException("Failed to start consumer manager", e);
        }
        NotificationTestServiceAddressingLocator notificationTestLocator = new NotificationTestServiceAddressingLocator();
        SubscriptionManagerServiceAddressingLocator managerLocator = new SubscriptionManagerServiceAddressingLocator();
        try {
            TestNotifyCallback testCallback = new TestNotifyCallback();
            EndpointReferenceType consumerEPR = consumer.createNotificationConsumer((NotifyCallback)testCallback);
            EndpointReferenceType epr = AddressingUtils.createEndpointReference((String)(ServiceHost.getBaseURL() + SERVICE_PATH), (ResourceKey)NotificationTestHome.GOOD_KEY);
            NotificationTestPortType port = notificationTestLocator.getNotificationTestPortTypePort(epr);
            Subscribe request = new Subscribe();
            request.setConsumerReference(consumerEPR);
            TopicExpressionType topicPath = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (Object)FOURTH_TOPIC);
            request.setTopicExpression(topicPath);
            SubscribeResponse response = port.subscribe(request);
            if (!testCallback.waitForCount(1, GridTestSuite.timeout)) {
                throw new Exception("timeout");
            }
            if (testCallback.getNotifyCount() != 1) {
                throw new Exception("expected one notification but got: " + testCallback.getNotifyCount());
            }
            SubscriptionManager manager = managerLocator.getSubscriptionManagerPort(response.getSubscriptionReference());
            manager.destroy(new Destroy());
        }
        catch (Exception e) {
            throw new RemoteException("Subscribe failed", e);
        }
        finally {
            try {
                consumer.stopListening();
            }
            catch (ContainerException e) {
                throw new RemoteException("Failed to stop consumer manager", e);
            }
        }
        return new SelfSubscribeResponse();
    }
}

