/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.notification;

import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.Stub;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.globus.gsi.GSIConstants;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.core.notification.SubscriptionManager;
import org.globus.wsrf.core.notification.service.SubscriptionManagerServiceAddressingLocator;
import org.globus.wsrf.impl.notification.NotificationTestHome;
import org.globus.wsrf.impl.security.TestConstants;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityDescriptor;
import org.globus.wsrf.test.GridTestCase;
import org.globus.wsrf.tests.notification.NotificationTestPortType;
import org.globus.wsrf.tests.notification.service.NotificationTestServiceAddressingLocator;
import org.globus.wsrf.utils.AddressingUtils;
import org.oasis.wsrf.lifetime.Destroy;

public class NotificationTestCase
extends GridTestCase {
    protected EndpointReferenceType testServiceEPR = null;
    protected EndpointReferenceType testServiceEPR2 = null;
    protected EndpointReferenceType badEPR = null;
    protected NotificationTestServiceAddressingLocator notificationTestLocator = new NotificationTestServiceAddressingLocator();
    protected NotificationTestPortType port = null;
    protected NotificationTestPortType port2 = null;
    protected NotificationTestPortType badPort = null;
    protected SubscriptionManagerServiceAddressingLocator managerLocator = new SubscriptionManagerServiceAddressingLocator();

    public NotificationTestCase(String name) {
        super(name);
    }

    protected void setAddress() throws Exception {
        String notificationTestServiceAddress = TEST_CONTAINER.getBaseURL() + "NotificationTestService";
        this.testServiceEPR = AddressingUtils.createEndpointReference((String)notificationTestServiceAddress, (ResourceKey)NotificationTestHome.GOOD_KEY);
        this.testServiceEPR2 = AddressingUtils.createEndpointReference((String)notificationTestServiceAddress, (ResourceKey)NotificationTestHome.GOOD_KEY_2);
        this.badEPR = AddressingUtils.createEndpointReference((String)notificationTestServiceAddress, (ResourceKey)NotificationTestHome.BAD_KEY);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.setAddress();
        this.port = this.notificationTestLocator.getNotificationTestPortTypePort(this.testServiceEPR);
        this.port2 = this.notificationTestLocator.getNotificationTestPortTypePort(this.testServiceEPR2);
        this.badPort = this.notificationTestLocator.getNotificationTestPortTypePort(this.badEPR);
    }

    protected void destroySubscription(EndpointReferenceType subscriptionEPR, ClientSecurityDescriptor desc) throws ServiceException, RemoteException {
        SubscriptionManager manager = this.managerLocator.getSubscriptionManagerPort(subscriptionEPR);
        if (desc != null) {
            ((Stub)manager)._setProperty("clientDescriptor", (Object)desc);
        }
        manager.destroy(new Destroy());
    }

    protected void destroySubscription(EndpointReferenceType subscriptionEPR) throws ServiceException, RemoteException {
        this.destroySubscription(subscriptionEPR, (ClientSecurityDescriptor)null);
    }

    protected void destroySubscription(EndpointReferenceType subscriptionEPR, String msgType) throws ServiceException, RemoteException {
        ClientSecurityDescriptor desc = new ClientSecurityDescriptor();
        desc.setAuthz(TestConstants.getConfiguredClientAuthz());
        if (msgType.equals("org.globus.security.secConv.msg.type")) {
            desc.setGSISecureConv(GSIConstants.SIGNATURE);
        } else if (msgType.equals("org.globus.security.secMsg.msg.type")) {
            desc.setGSISecureMsg(GSIConstants.SIGNATURE);
        }
        this.destroySubscription(subscriptionEPR, desc);
    }
}

