/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.notification;

import org.apache.axis.Constants;
import org.apache.axis.message.MessageElement;
import org.apache.axis.types.URI;
import org.globus.wsrf.WSNConstants;
import org.globus.wsrf.impl.notification.NotificationTestCase;
import org.globus.wsrf.impl.notification.NotificationTestService;
import org.oasis.wsrf.properties.GetResourcePropertyResponse;

public class NotificationProducerRPTests
extends NotificationTestCase {
    public NotificationProducerRPTests(String name) {
        super(name);
    }

    public void testGetTopics() throws Exception {
        boolean foundEmptyTopic = false;
        boolean foundTestTopic = false;
        boolean foundThirdTopic = false;
        GetResourcePropertyResponse response = this.port.getResourceProperty(WSNConstants.TOPIC);
        MessageElement[] topics = response.get_any();
        NotificationProducerRPTests.assertEquals((int)7, (int)topics.length);
        for (int i = 0; i < topics.length; ++i) {
            MessageElement topic = topics[i];
            NotificationProducerRPTests.assertEquals((Object)topic.getQName(), (Object)WSNConstants.TOPIC);
            if (topic.getValueAsType(Constants.XSD_QNAME).equals(NotificationTestService.EMPTY_TOPIC)) {
                foundEmptyTopic = true;
            }
            if (topic.getValueAsType(Constants.XSD_QNAME).equals(NotificationTestService.TEST_TOPIC)) {
                foundTestTopic = true;
            }
            if (!topic.getValueAsType(Constants.XSD_QNAME).equals(NotificationTestService.THIRD_TOPIC)) continue;
            foundThirdTopic = true;
        }
        NotificationProducerRPTests.assertTrue((boolean)foundEmptyTopic);
        NotificationProducerRPTests.assertTrue((boolean)foundTestTopic);
        NotificationProducerRPTests.assertTrue((boolean)foundThirdTopic);
    }

    public void testGetFixedTopicSet() throws Exception {
        GetResourcePropertyResponse response = this.port.getResourceProperty(WSNConstants.FIXED_TOPIC_SET);
        MessageElement[] topics = response.get_any();
        NotificationProducerRPTests.assertEquals((int)1, (int)topics.length);
        MessageElement topic = topics[0];
        NotificationProducerRPTests.assertEquals((Object)WSNConstants.FIXED_TOPIC_SET, (Object)topic.getQName());
        NotificationProducerRPTests.assertEquals((boolean)true, (boolean)((Boolean)topic.getValueAsType(Constants.XSD_BOOLEAN)));
    }

    public void testGetDialects() throws Exception {
        GetResourcePropertyResponse response = this.port.getResourceProperty(WSNConstants.TOPIC_EXPRESSION_DIALECTS);
        MessageElement[] topics = response.get_any();
        NotificationProducerRPTests.assertEquals((int)1, (int)topics.length);
        MessageElement topic = topics[0];
        NotificationProducerRPTests.assertEquals((Object)WSNConstants.TOPIC_EXPRESSION_DIALECTS, (Object)topic.getQName());
        NotificationProducerRPTests.assertEquals((String)"http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (String)((URI)topic.getValueAsType(Constants.XSD_ANYURI)).toString());
    }
}

