/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.handlers;

import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;
import javax.xml.soap.SOAPEnvelope;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Call;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.gssapi.auth.NoAuthorization;
import org.globus.wsrf.WSRFConstants;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.test.GridTestCase;
import org.globus.wsrf.tests.basic.CreateResource;
import org.globus.wsrf.tests.basic.TestPortType;
import org.globus.wsrf.tests.basic.service.TestServiceAddressingLocator;
import org.globus.wsrf.tests.security.GsiSecConvIntegrity;
import org.globus.wsrf.tests.security.SecurityTestPortType;
import org.globus.wsrf.tests.security.service.SecurityTestServiceAddressingLocator;

public class WSATests
extends GridTestCase {
    private TestServiceAddressingLocator locator = new TestServiceAddressingLocator();
    static /* synthetic */ Class class$org$globus$wsrf$handlers$WSATests;

    public WSATests(String name) {
        super(name);
    }

    public void testFaultAtPivotHandler() throws Exception {
        block2: {
            String address = TEST_CONTAINER.getBaseURL() + "TestService" + "foobar";
            EndpointReferenceType epr = new EndpointReferenceType(new URI(address));
            TestPortType port = this.locator.getTestPortTypePort(epr);
            this.setStubProperties((Stub)port);
            try {
                port.createResource(new CreateResource());
                WSATests.fail((String)"did not throw right exception");
            }
            catch (AxisFault e) {
                if (e.getMessage().indexOf("The AXIS engine could not find a target service to invoke") != -1) break block2;
                e.printStackTrace();
                WSATests.fail((String)("did not get the right exception: " + e.getMessage()));
            }
        }
    }

    public void testFaultInService() throws Exception {
        block2: {
            String address = TEST_CONTAINER.getBaseURL() + "TestService";
            EndpointReferenceType epr = new EndpointReferenceType(new URI(address));
            TestPortType port = this.locator.getTestPortTypePort(epr);
            this.setStubProperties((Stub)port);
            try {
                port.getResourceProperty(WSRFConstants.CURRENT_TIME);
                WSATests.fail((String)"did not throw right exception");
            }
            catch (AxisFault e) {
                if (e.getMessage().indexOf("Failed to acquire resource") != -1) break block2;
                e.printStackTrace();
                WSATests.fail((String)("did not get the right exception: " + e.getMessage()));
            }
        }
        this.checkHeaders(this.locator.getCall(), "TestService");
    }

    public void testFaultAtAddressingHandler() throws Exception {
        block2: {
            String address = TEST_CONTAINER.getBaseURL() + "TestService";
            EndpointReferenceType epr = new EndpointReferenceType(new URI(address));
            epr.getProperties().add((Object)ObjectSerializer.toSOAPElement((Object)"BadKeyValue", (QName)new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "BadKey")));
            TestPortType port = this.locator.getTestPortTypePort(epr);
            this.setStubProperties((Stub)port);
            try {
                port.getResourceProperty(WSRFConstants.CURRENT_TIME);
                WSATests.fail((String)"did not throw right exception");
            }
            catch (AxisFault e) {
                if (e.getMessage().indexOf("Unsupported addressing header") != -1) break block2;
                e.printStackTrace();
                WSATests.fail((String)("did not get the right exception: " + e.getMessage()));
            }
        }
    }

    public void testFaultAtJAXRPCHandler() throws Exception {
        block2: {
            ClassLoader loader = (class$org$globus$wsrf$handlers$WSATests == null ? (class$org$globus$wsrf$handlers$WSATests = WSATests.class$("org.globus.wsrf.handlers.WSATests")) : class$org$globus$wsrf$handlers$WSATests).getClassLoader();
            InputStream in = loader.getResourceAsStream("org/globus/wsrf/handlers/badcred.pem");
            WSATests.assertTrue((String)"Unable to obtain cred", (in != null ? 1 : 0) != 0);
            String address = TEST_CONTAINER.getBaseURL() + "TestService";
            EndpointReferenceType epr = new EndpointReferenceType(new URI(address));
            TestPortType port = this.locator.getTestPortTypePort(epr);
            this.setStubProperties((Stub)port);
            GlobusGSSCredentialImpl cred = new GlobusGSSCredentialImpl(new GlobusCredential(in), 1);
            ((Stub)port)._setProperty("org.globus.gsi.credentials", (Object)cred);
            ((Stub)port)._setProperty("org.globus.security.secMsg.msg.type", (Object)GSIConstants.SIGNATURE);
            try {
                port.createResource(new CreateResource());
                WSATests.fail((String)"did not throw right exception");
            }
            catch (AxisFault e) {
                if (e.getMessage().indexOf("Unknown CA") != -1) break block2;
                e.printStackTrace();
                WSATests.fail((String)("did not get the right exception: " + e.getMessage()));
            }
        }
        this.checkHeaders(this.locator.getCall(), "TestService");
    }

    public void testFaultAtAxisHandler() throws Exception {
        SecurityTestServiceAddressingLocator locator;
        block2: {
            locator = new SecurityTestServiceAddressingLocator();
            String address = TEST_CONTAINER.getBaseURL() + "SecurityTestService";
            EndpointReferenceType epr = new EndpointReferenceType(new URI(address));
            SecurityTestPortType port = locator.getSecurityTestPortTypePort(epr);
            this.setStubProperties((Stub)port);
            try {
                port.gsiSecConvIntegrity(new GsiSecConvIntegrity());
                WSATests.fail((String)"did not throw right exception");
            }
            catch (AxisFault e) {
                if (e.getMessage().indexOf("GSI Secure Conversation (signature only) authentication required") != -1) break block2;
                e.printStackTrace();
                WSATests.fail((String)("did not get the right exception: " + e.getMessage()));
            }
        }
        this.checkHeaders(locator.getCall(), "SecurityTestService");
    }

    private void checkHeaders(Call call, String service) throws Exception {
        org.apache.axis.message.SOAPEnvelope env = (org.apache.axis.message.SOAPEnvelope)call.getResponseMessage().getSOAPPart().getEnvelope();
        AddressingHeaders headers = new AddressingHeaders((SOAPEnvelope)env);
        WSATests.assertTrue((headers.getFrom() != null ? 1 : 0) != 0);
        WSATests.assertTrue((headers.getFrom().getAddress().toString().indexOf(service) != -1 ? 1 : 0) != 0);
        WSATests.assertTrue((headers.getAction() != null ? 1 : 0) != 0);
        WSATests.assertEquals((String)"http://schemas.xmlsoap.org/ws/2004/03/addressing/fault", (String)headers.getAction().toString());
    }

    private void setStubProperties(Stub s) {
        s._setProperty("org.globus.gsi.authorization", (Object)NoAuthorization.getInstance());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

