/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.handlers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.util.Hashtable;
import javax.xml.rpc.Stub;
import org.apache.axis.AxisFault;
import org.apache.axis.transport.http.HTTPConstants;
import org.globus.util.http.HTTPProtocol;
import org.globus.util.http.HTTPResponseParser;
import org.globus.wsrf.test.GridTestCase;
import org.globus.wsrf.tests.basic.CreateResource;
import org.globus.wsrf.tests.basic.CreateResourceResponse;
import org.globus.wsrf.tests.basic.GetInstanceInfoResponse;
import org.globus.wsrf.tests.basic.NoPermissionFault;
import org.globus.wsrf.tests.basic.TestLocalInvocation;
import org.globus.wsrf.tests.basic.TestPortType;
import org.globus.wsrf.tests.basic.service.TestServiceAddressingLocator;
import org.oasis.wsrf.lifetime.Destroy;
import org.oasis.wsrf.lifetime.ImmediateResourceTermination;
import org.oasis.wsrf.lifetime.WSResourceLifetimeServiceAddressingLocator;

public class BasicTests
extends GridTestCase {
    public BasicTests(String name) {
        super(name);
    }

    public void testServiceNotFound() throws Exception {
        BasicTests.assertTrue((boolean)TEST_CONTAINER.getBaseURL().endsWith("/"));
        this.runTest(TEST_CONTAINER.getBaseURL());
        this.runTest(TEST_CONTAINER.getBaseURL() + "F");
        String url = TEST_CONTAINER.getBaseURL();
        this.runTest(url.substring(0, url.length() - 1));
    }

    private void runTest(String strUrl) throws Exception {
        System.out.println(strUrl);
        WSResourceLifetimeServiceAddressingLocator locator = new WSResourceLifetimeServiceAddressingLocator();
        URL url = new URL(strUrl);
        try {
            ImmediateResourceTermination port = locator.getImmediateResourceTerminationPort(url);
            port.destroy(new Destroy());
        }
        catch (AxisFault e) {
            BasicTests.assertTrue((boolean)e.getFaultCode().getLocalPart().equals("Server.NoService"));
        }
    }

    public void testWrongWSDLCall() throws Exception {
        String address = TEST_CONTAINER.getBaseURL() + "TestService" + "WrongWSDL";
        WSResourceLifetimeServiceAddressingLocator locator = new WSResourceLifetimeServiceAddressingLocator();
        URL url = new URL(address);
        ImmediateResourceTermination port = locator.getImmediateResourceTerminationPort(url);
        try {
            port.destroy(new Destroy());
        }
        catch (AxisFault e) {
            BasicTests.assertTrue((boolean)e.getMessage().startsWith("WSDLException: faultCode=OTHER_ERROR: [CORE] wsdl binding information missing"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void testWrongWSDLGet() throws Exception {
        block32: {
            Exception e222222;
            OutputStream out;
            InputStream in;
            Socket socket;
            block28: {
                String wsdlLocation = TEST_CONTAINER.getBaseURL() + "TestService" + "WrongWSDL?wsdl";
                URL url = new URL(wsdlLocation);
                socket = null;
                in = null;
                out = null;
                socket = new Socket(TEST_CONTAINER.getHost(), TEST_CONTAINER.getPort());
                out = socket.getOutputStream();
                String msg = HTTPProtocol.createGETHeader((String)url.getFile(), (String)TEST_CONTAINER.getHost(), (String)"TestClient");
                out.write(msg.getBytes());
                out.flush();
                in = socket.getInputStream();
                HTTPResponseParser response = new HTTPResponseParser(in);
                byte[] buf = new byte[1024];
                ByteArrayOutputStream outb = new ByteArrayOutputStream();
                long len = response.getContentLength();
                int bytes = 0;
                if (len == -1L) {
                    while ((bytes = in.read(buf)) != -1) {
                        outb.write(buf, 0, bytes);
                    }
                } else {
                    int totalBytes = 0;
                    while ((long)totalBytes < len && (bytes = in.read(buf)) != -1) {
                        outb.write(buf, 0, bytes);
                        totalBytes += bytes;
                    }
                }
                byte[] data = outb.toByteArray();
                System.out.println("Content type: " + response.getContentType());
                System.out.println("Reply: " + new String(data));
                BasicTests.assertTrue((response.getStatusCode() >= 300 ? 1 : 0) != 0);
                BasicTests.assertTrue((boolean)response.getContentType().startsWith("text/html"));
                Object var15_15 = null;
                if (in == null) break block28;
                try {
                    in.close();
                }
                catch (Exception e222222) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e222222) {
                    // empty catch block
                }
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception e222222) {}
            }
            break block32;
            {
                catch (IOException e3) {
                    Exception e222222;
                    BasicTests.fail((String)e3.getMessage());
                    Object var15_16 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception e222222) {
                            // empty catch block
                        }
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception e222222) {
                            // empty catch block
                        }
                    }
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Exception e222222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Exception e222222;
                Object var15_17 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e222222) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e222222) {
                        // empty catch block
                    }
                }
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception e222222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public void testHTTP11() throws Exception {
        URL url = new URL(TEST_CONTAINER.getBaseURL() + "TestService");
        TestServiceAddressingLocator locator = new TestServiceAddressingLocator();
        TestPortType port = locator.getTestPortTypePort(url);
        CreateResourceResponse response = null;
        ((Stub)port)._setProperty("axis.transport.version", (Object)HTTPConstants.HEADER_PROTOCOL_V10);
        response = port.createResource(new CreateResource());
        ((Stub)port)._setProperty("axis.transport.version", (Object)HTTPConstants.HEADER_PROTOCOL_V11);
        response = port.createResource(new CreateResource());
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put(HTTPConstants.HEADER_TRANSFER_ENCODING, HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED);
        ((Stub)port)._setProperty("HTTP-Request-Headers", p);
        response = port.createResource(new CreateResource());
    }

    public void testScopingAndServiceLifecycle() throws Exception {
        TestServiceAddressingLocator locator = new TestServiceAddressingLocator();
        URL url = null;
        TestPortType port = null;
        url = new URL(TEST_CONTAINER.getBaseURL() + "TestService");
        port = locator.getTestPortTypePort(url);
        GetInstanceInfoResponse response = null;
        response = port.getInstanceInfo(null);
        BasicTests.assertTrue((response.getInstances() > 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((response.getInitCalls() > 0 ? 1 : 0) != 0);
        BasicTests.assertEquals((int)0, (int)response.getDestroyCalls());
        BasicTests.assertTrue((boolean)response.isProviderInit());
        port.resetNumInstances(null);
        response = port.getInstanceInfo(null);
        BasicTests.assertEquals((int)0, (int)response.getInstances());
        BasicTests.assertEquals((int)0, (int)response.getInitCalls());
        BasicTests.assertEquals((int)0, (int)response.getDestroyCalls());
        BasicTests.assertFalse((boolean)response.isProviderInit());
        response = port.getInstanceInfo(null);
        BasicTests.assertEquals((int)0, (int)response.getInstances());
        BasicTests.assertEquals((int)0, (int)response.getInitCalls());
        BasicTests.assertEquals((int)0, (int)response.getDestroyCalls());
        BasicTests.assertFalse((boolean)response.isProviderInit());
        response = port.getInstanceInfo(null);
        BasicTests.assertEquals((int)0, (int)response.getInstances());
        BasicTests.assertEquals((int)0, (int)response.getInitCalls());
        BasicTests.assertEquals((int)0, (int)response.getDestroyCalls());
        BasicTests.assertFalse((boolean)response.isProviderInit());
        url = new URL(TEST_CONTAINER.getBaseURL() + "TestService" + "Request");
        port = locator.getTestPortTypePort(url);
        port.resetNumInstances(null);
        response = port.getInstanceInfo(null);
        BasicTests.assertEquals((int)1, (int)response.getInstances());
        BasicTests.assertEquals((int)1, (int)response.getInitCalls());
        BasicTests.assertEquals((int)1, (int)response.getDestroyCalls());
        BasicTests.assertFalse((boolean)response.isProviderInit());
        response = port.getInstanceInfo(null);
        BasicTests.assertEquals((int)2, (int)response.getInstances());
        BasicTests.assertEquals((int)2, (int)response.getInitCalls());
        BasicTests.assertEquals((int)2, (int)response.getDestroyCalls());
        BasicTests.assertFalse((boolean)response.isProviderInit());
        response = port.getInstanceInfo(null);
        BasicTests.assertEquals((int)3, (int)response.getInstances());
        BasicTests.assertEquals((int)3, (int)response.getInitCalls());
        BasicTests.assertEquals((int)3, (int)response.getDestroyCalls());
        BasicTests.assertFalse((boolean)response.isProviderInit());
    }

    public void testLocalInvocation() throws Exception {
        URL url = new URL(TEST_CONTAINER.getBaseURL() + "TestService");
        TestServiceAddressingLocator locator = new TestServiceAddressingLocator();
        TestPortType port = locator.getTestPortTypePort(url);
        TestLocalInvocation request = new TestLocalInvocation();
        port.testLocalInvocation(request);
    }

    public void testSimpleFault() throws Exception {
        URL url = new URL(TEST_CONTAINER.getBaseURL() + "TestService");
        TestServiceAddressingLocator locator = new TestServiceAddressingLocator();
        TestPortType port = locator.getTestPortTypePort(url);
        try {
            CreateResourceResponse response = port.createResource(null);
            BasicTests.fail((String)"did not throw an exception");
        }
        catch (NoPermissionFault e) {
            // empty catch block
        }
    }
}

