/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.service.wsrf.sgr;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.globus.wsrf.ResourceContext;
import uk.org.ogsadai.exception.DAIClassMissingMethodException;
import uk.org.ogsadai.exception.DAIClassNotFoundException;
import uk.org.ogsadai.exception.DAIClassSecurityException;
import uk.org.ogsadai.exception.DAIMethodInvocationException;
import uk.org.ogsadai.service.wsrf.sgr.ServiceGroupRegistrationConfigException;
import uk.org.ogsadai.service.wsrf.sgr.ServiceGroupRegistrationException;

public class ServiceGroupRegistrationClientWrapper {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2006.";
    private static final String CLASS_NAME = "org.globus.wsrf.impl.servicegroup.client.ServiceGroupRegistrationClient";
    private static final String METHOD_NAME = "register";
    private static final Class[] PARAM_TYPES = new Class[]{ResourceContext.class, EndpointReferenceType.class, String.class};

    public static void register(ResourceContext resourceContext, EndpointReferenceType epr, String registrationFileName) throws ServiceGroupRegistrationConfigException, ServiceGroupRegistrationException {
        try {
            Class<?> classDef = Class.forName(CLASS_NAME);
            Method registerMethod = classDef.getMethod(METHOD_NAME, PARAM_TYPES);
            Object[] args = new Object[]{resourceContext, epr, registrationFileName};
            registerMethod.invoke(null, args);
        }
        catch (ClassNotFoundException e) {
            DAIClassNotFoundException ex = new DAIClassNotFoundException(CLASS_NAME);
            throw new ServiceGroupRegistrationConfigException((Throwable)ex);
        }
        catch (SecurityException e) {
            DAIClassSecurityException ex = new DAIClassSecurityException(CLASS_NAME, METHOD_NAME, PARAM_TYPES);
            throw new ServiceGroupRegistrationConfigException((Throwable)ex);
        }
        catch (NoSuchMethodException e) {
            DAIClassMissingMethodException ex = new DAIClassMissingMethodException(CLASS_NAME, METHOD_NAME, PARAM_TYPES);
            throw new ServiceGroupRegistrationConfigException((Throwable)ex);
        }
        catch (IllegalArgumentException e) {
            DAIMethodInvocationException ex = new DAIMethodInvocationException(CLASS_NAME, METHOD_NAME, PARAM_TYPES);
            throw new ServiceGroupRegistrationConfigException((Throwable)ex);
        }
        catch (IllegalAccessException e) {
            DAIMethodInvocationException ex = new DAIMethodInvocationException(CLASS_NAME, METHOD_NAME, PARAM_TYPES);
            throw new ServiceGroupRegistrationConfigException((Throwable)ex);
        }
        catch (InvocationTargetException e) {
            throw new ServiceGroupRegistrationConfigException(e);
        }
    }
}

