/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.service.wsrf.resource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.globus.wsrf.InvalidResourceKeyException;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.RemoveNotSupportedException;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceHome;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.jndi.Initializable;
import uk.org.ogsadai.common.SecurityContextProvider;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.dataresource.DataResourceAccessor;
import uk.org.ogsadai.engine.ConcurrencySettings;
import uk.org.ogsadai.service.authorization.AccessAuthorizer;
import uk.org.ogsadai.service.resource.ResourceCreationException;
import uk.org.ogsadai.service.resource.ResourceKeyInvalidException;
import uk.org.ogsadai.service.resource.config.ActivitiesConfig;
import uk.org.ogsadai.service.wsrf.WSRFConstants;
import uk.org.ogsadai.service.wsrf.resource.DataServiceResourceWrapper;
import uk.org.ogsadai.service.wsrf.resource.MissingKeyClassException;
import uk.org.ogsadai.sessions.SessionComponentFactory;

public class DataServiceResourceWrapperHome
implements ResourceHome,
Initializable {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2005.";
    private static DAILogger LOG = DAILogger.getLogger((Class)DataServiceResourceWrapperHome.class);
    private Class mKeyTypeClass = null;
    private Map mResources = null;

    public ResourceKey create(Object id, DataResourceAccessor dataResourceAccessor, ActivitiesConfig activitiesConfig, SessionComponentFactory sessionComponentFactory, SecurityContextProvider securityContextProvider, ConcurrencySettings concurrency, AccessAuthorizer authority) throws ResourceCreationException, ResourceKeyInvalidException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entered create...");
        }
        DataServiceResourceWrapper resource = new DataServiceResourceWrapper(id, dataResourceAccessor, activitiesConfig, sessionComponentFactory, securityContextProvider, concurrency, authority);
        SimpleResourceKey key = new SimpleResourceKey(WSRFConstants.DATA_SERVICE_RESOURCE_KEY, resource.getID());
        try {
            this.add((ResourceKey)key, resource);
        }
        catch (InvalidResourceKeyException e) {
            throw new ResourceKeyInvalidException((Object)key);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exiting create.");
        }
        return key;
    }

    public void initialize() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entered initialize...");
        }
        if (this.mResources != null) {
            return;
        }
        if (this.mKeyTypeClass == null) {
            throw new MissingKeyClassException();
        }
        this.mResources = Collections.synchronizedMap(new HashMap());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exiting initialize.");
        }
    }

    public Class getKeyTypeClass() {
        return this.mKeyTypeClass;
    }

    public QName getKeyTypeName() {
        return WSRFConstants.DATA_SERVICE_RESOURCE_KEY;
    }

    public void setResourceKeyType(String clazz) throws ClassNotFoundException {
        this.mKeyTypeClass = Class.forName(clazz);
    }

    public Resource find(ResourceKey key) throws ResourceException, NoSuchResourceException, InvalidResourceKeyException {
        if (key == null) {
            throw new InvalidResourceKeyException();
        }
        Resource resource = (Resource)this.mResources.get(key);
        if (resource == null) {
            throw new NoSuchResourceException();
        }
        return resource;
    }

    public void remove(ResourceKey key) throws ResourceException, NoSuchResourceException, InvalidResourceKeyException, RemoveNotSupportedException {
        if (key == null) {
            throw new InvalidResourceKeyException();
        }
        if (!this.mResources.containsKey(key)) {
            throw new NoSuchResourceException();
        }
        this.mResources.remove(key);
    }

    public void add(ResourceKey key, Object resource) throws InvalidResourceKeyException, IllegalArgumentException {
        if (key == null) {
            throw new InvalidResourceKeyException();
        }
        if (resource == null) {
            throw new IllegalArgumentException("resource must not be null");
        }
        if (!DataServiceResourceWrapper.class.isInstance(resource)) {
            throw new IllegalArgumentException("resource must be an instance of " + DataServiceResourceWrapper.class.toString());
        }
        if (LOG.isDebugEnabled()) {
            String friendlyResourceName = key.getValue().toString();
            LOG.debug("Adding resource: " + friendlyResourceName);
        }
        this.mResources.put(key, resource);
    }

    public Object[] getKeys() {
        return this.mResources.keySet().toArray();
    }

    public boolean contains(ResourceKey key) {
        return this.mResources.containsKey(key);
    }
}

