/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.service.wsrf.resource;

import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceIdentifier;
import org.globus.wsrf.ResourceLifetime;
import org.globus.wsrf.ResourceProperties;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.impl.SimpleResourcePropertySet;
import uk.org.ogsadai.common.SecurityContextProvider;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.properties.Properties;
import uk.org.ogsadai.common.properties.PropertiesImpl;
import uk.org.ogsadai.common.properties.PropertyListener;
import uk.org.ogsadai.dataresource.DataResourceAccessor;
import uk.org.ogsadai.engine.ConcurrencySettings;
import uk.org.ogsadai.service.authorization.AccessAuthorizer;
import uk.org.ogsadai.service.resource.DataServiceResource;
import uk.org.ogsadai.service.resource.ResourceCreationException;
import uk.org.ogsadai.service.resource.config.ActivitiesConfig;
import uk.org.ogsadai.service.wsrf.WSRFConstants;
import uk.org.ogsadai.service.wsrf.properties.DataServiceResourcePropertyFactory;
import uk.org.ogsadai.service.wsrf.properties.WSRFPropertyListener;
import uk.org.ogsadai.sessions.SessionComponentFactory;

public class DataServiceResourceWrapper
implements Resource,
ResourceLifetime,
ResourceIdentifier,
ResourceProperties {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2006.";
    private static DAILogger LOG = DAILogger.getLogger((Class)DataServiceResourceWrapper.class);
    private DataServiceResource mDataServiceResource = null;
    private Calendar mTerminationTime = null;
    private ResourcePropertySet mPropertySet = null;

    public DataServiceResourceWrapper(Object id, DataResourceAccessor dataResourceAccessor, ActivitiesConfig activitiesConfig, SessionComponentFactory sessionComponentFactory, SecurityContextProvider securityContextProvider, ConcurrencySettings concurrency, AccessAuthorizer authority) throws ResourceCreationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entered DataServiceResource constructor...");
        }
        if (securityContextProvider == null) {
            throw new IllegalArgumentException("securityContextProvider must not be null");
        }
        this.mDataServiceResource = new DataServiceResource(id, activitiesConfig, dataResourceAccessor, sessionComponentFactory, concurrency, authority);
        this.buildResourcePropertySet(securityContextProvider);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exiting DataServiceResource constructor.");
        }
    }

    private void buildResourcePropertySet(SecurityContextProvider securityContextProvider) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Building Globus ResourcePropertySet");
        }
        this.mPropertySet = new SimpleResourcePropertySet(WSRFConstants.RP_SET);
        Properties properties = this.mDataServiceResource.getProperties();
        DataServiceResourcePropertyFactory factory = new DataServiceResourcePropertyFactory(securityContextProvider);
        WSRFPropertyListener listener = new WSRFPropertyListener(this.mPropertySet, factory);
        properties.addPropertyListener((PropertyListener)listener);
        PropertiesImpl tempProperties = new PropertiesImpl();
        tempProperties.addPropertyListener((PropertyListener)listener);
        tempProperties.putAll((Map)properties);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Globus ResourcePropertySet Built");
        }
    }

    public void setTerminationTime(Calendar time) {
        this.mTerminationTime = time;
    }

    public Calendar getTerminationTime() {
        return this.mTerminationTime;
    }

    public Calendar getCurrentTime() {
        return Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    }

    public Object getID() {
        return this.mDataServiceResource.getID();
    }

    public ResourcePropertySet getResourcePropertySet() {
        return this.mPropertySet;
    }

    public DataServiceResource getDataServiceResource() {
        return this.mDataServiceResource;
    }
}

