/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.service.wsrf.properties;

import javax.xml.namespace.QName;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertySet;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.properties.Property;
import uk.org.ogsadai.common.properties.PropertyEvent;
import uk.org.ogsadai.common.properties.PropertyListener;
import uk.org.ogsadai.service.wsrf.properties.GTResourcePropertySetUpdateException;
import uk.org.ogsadai.service.wsrf.properties.ResourcePropertyFactory;

public class WSRFPropertyListener
implements PropertyListener {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)WSRFPropertyListener.class);
    private final ResourcePropertySet mPropertySet;
    private final ResourcePropertyFactory mFactory;

    public WSRFPropertyListener(ResourcePropertySet propertySet, ResourcePropertyFactory factory) {
        if (propertySet == null) {
            throw new IllegalArgumentException("propertySet must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.mPropertySet = propertySet;
        this.mFactory = factory;
    }

    public synchronized void propertyAdded(PropertyEvent event) {
        Property property = event.getProperty();
        ResourceProperty rp = this.mFactory.createResourceProperty(property);
        boolean added = this.mPropertySet.add(rp);
        if (added) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resource property added: " + property.getName());
            }
        } else {
            GTResourcePropertySetUpdateException ex = new GTResourcePropertySetUpdateException(property.getName(), true);
            LOG.error((Throwable)((Object)ex));
        }
    }

    public synchronized void propertyRemoved(PropertyEvent event) {
        QName name = event.getProperty().getName();
        boolean removed = this.mPropertySet.remove(name);
        if (removed) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resource property removed: " + name);
            }
        } else {
            GTResourcePropertySetUpdateException ex = new GTResourcePropertySetUpdateException(name, false);
            LOG.error((Throwable)((Object)ex));
        }
    }

    public synchronized void propertyUpdated(PropertyEvent event) {
        this.propertyAdded(event);
    }
}

