/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.service.wsrf.properties;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.encoding.SerializationException;
import org.globus.wsrf.impl.BaseResourceProperty;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.org.ogsadai.common.SecurityContext;
import uk.org.ogsadai.common.SecurityContextProvider;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.properties.Property;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class DataServiceResourceProperty
extends BaseResourceProperty {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2005.";
    private static DAILogger LOG = DAILogger.getLogger((Class)DataServiceResourceProperty.class);
    private Property mProperty;
    private SecurityContextProvider mSecContextProvider;

    public DataServiceResourceProperty(QName name, Property property) {
        super(name);
        this.mProperty = property;
        this.mProperty.addObserver(this.createPropertyObserver());
    }

    private Observer createPropertyObserver() {
        Observer observer = new Observer(){

            public void update(Observable property, Object value) {
            }
        };
        return observer;
    }

    public void setSecurityContextProvider(SecurityContextProvider securityContextProvider) {
        this.mSecContextProvider = securityContextProvider;
    }

    public void add(Object value) {
        this.setValue(value);
    }

    public boolean remove(Object value) {
        this.setValue(null);
        return true;
    }

    public Object get(int index) {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof Object[]) {
            return ((Object[])value)[index];
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Property value: " + value);
        }
        return value;
    }

    public void set(int index, Object value) {
        this.setValue(value);
    }

    public void clear() {
        this.setValue(null);
    }

    public int size() {
        Object value = this.getValue();
        if (value == null) {
            return 0;
        }
        if (value instanceof Object[]) {
            return ((Object[])value).length;
        }
        if (value instanceof Collection) {
            return ((Collection)value).size();
        }
        return 1;
    }

    public boolean isEmpty() {
        return this.getValue() == null;
    }

    public Iterator iterator() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof Object[]) {
            return Arrays.asList((Object[])value).iterator();
        }
        if (value instanceof Collection) {
            return ((Collection)value).iterator();
        }
        return Arrays.asList(value).iterator();
    }

    public SOAPElement[] toSOAPElements() throws SerializationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Converting resource property into SOAPElement");
        }
        Object value = this.getValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Value type: " + value.getClass());
            LOG.debug("Value: " + value);
        }
        if (value == null) {
            return new SOAPElement[]{ObjectSerializer.toSOAPElement(null, (QName)this.getMetaData().getName(), (boolean)this.getMetaData().isNillable())};
        }
        if (value instanceof Collection) {
            SOAPElement[] ret = new SOAPElement[((Collection)value).size()];
            Iterator iter = ((Collection)value).iterator();
            int i = 0;
            while (iter.hasNext()) {
                Object obj = iter.next();
                ret[i++] = ObjectSerializer.toSOAPElement(obj, (QName)this.getMetaData().getName(), (boolean)this.getMetaData().isNillable());
            }
            return ret;
        }
        if (value instanceof Object[]) {
            Object[] obj = (Object[])value;
            SOAPElement[] ret = new SOAPElement[obj.length];
            int len = obj.length;
            for (int i = 0; i < len; ++i) {
                ret[i] = ObjectSerializer.toSOAPElement((Object)obj[i], (QName)this.getMetaData().getName(), (boolean)this.getMetaData().isNillable());
            }
            return ret;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Serializing to a SOAP element: " + value);
            LOG.debug("  SOAP element object: " + value);
            LOG.debug("  SOAP element name: " + this.getMetaData().getName());
            LOG.debug("  SOAP element nillable: " + this.getMetaData().isNillable());
            if (value instanceof Node) {
                LOG.debug(XMLUtilities.xmlDOMToString((Node)((Node)value)));
            }
        }
        SOAPElement soap = ObjectSerializer.toSOAPElement((Object)value, (QName)this.getMetaData().getName(), (boolean)this.getMetaData().isNillable());
        return new SOAPElement[]{soap};
    }

    public Element[] toElements() throws SerializationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Serializing property value to Element array.");
        }
        Object value = this.getValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Globus property value: " + value);
        }
        if (value == null) {
            if (this.getMetaData().isNillable()) {
                return new Element[]{ObjectSerializer.toElement(null, (QName)this.getMetaData().getName(), (boolean)this.getMetaData().isNillable())};
            }
            return null;
        }
        if (value instanceof Collection) {
            Element[] ret = new Element[((Collection)value).size()];
            Iterator iter = ((Collection)value).iterator();
            int i = 0;
            while (iter.hasNext()) {
                Object obj = iter.next();
                ret[i++] = ObjectSerializer.toElement(obj);
            }
            return ret;
        }
        if (value instanceof Object[]) {
            Object[] obj = (Object[])value;
            Element[] ret = new Element[obj.length];
            int len = obj.length;
            for (int i = 0; i < len; ++i) {
                ret[i] = ObjectSerializer.toElement((Object)obj[i], (QName)this.getMetaData().getName(), (boolean)this.getMetaData().isNillable());
            }
            return ret;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Serializing to Element array of size 1");
        }
        Element[] ret = new Element[]{ObjectSerializer.toElement((Object)value, (QName)this.getMetaData().getName(), (boolean)this.getMetaData().isNillable())};
        if (LOG.isDebugEnabled()) {
            LOG.debug("Serialized value: " + ret[0]);
        }
        return ret;
    }

    private Object getValue() {
        if (this.mSecContextProvider != null) {
            SecurityContext sec = this.mSecContextProvider.getSecurityContext();
            this.mProperty.setSecurityContext(sec);
        }
        Object value = null;
        try {
            value = this.mProperty.getValue();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return value;
    }

    private void setValue(Object value) {
        if (this.mSecContextProvider != null) {
            SecurityContext sec = this.mSecContextProvider.getSecurityContext();
            this.mProperty.setSecurityContext(sec);
        }
        try {
            this.mProperty.setValue(value);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }
}

