/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.service.wsrf.dataservice.impl;

import java.io.File;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.apache.axis.MessageContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.globus.gsi.jaas.JaasGssUtil;
import org.globus.gsi.jaas.JaasSubject;
import org.globus.wsrf.InvalidResourceKeyException;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.RemoveNotSupportedException;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceContextException;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.security.SecurityManager;
import org.globus.wsrf.utils.AddressingUtils;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.client.toolkit.soap.AttachmentManager;
import uk.org.ogsadai.common.GridCredentialAccessException;
import uk.org.ogsadai.common.SecurityContext;
import uk.org.ogsadai.common.SecurityContextProvider;
import uk.org.ogsadai.common.files.DAIFileNotFoundException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.msgs.MessageID;
import uk.org.ogsadai.common.serializer.DAISerializationException;
import uk.org.ogsadai.common.serializer.SerializerUtils;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.dataresource.DataResourceAccessor;
import uk.org.ogsadai.engine.ConcurrencySettings;
import uk.org.ogsadai.engine.IllegalConcurrencySettingException;
import uk.org.ogsadai.engine.RequestContext;
import uk.org.ogsadai.exception.AuthorisationFaultException;
import uk.org.ogsadai.exception.DAIAuthorizationException;
import uk.org.ogsadai.exception.DAIException;
import uk.org.ogsadai.exception.DAIExceptionInformation;
import uk.org.ogsadai.exception.InternalFaultException;
import uk.org.ogsadai.exception.NonOGSADAIExceptionWrapper;
import uk.org.ogsadai.exception.ServerException;
import uk.org.ogsadai.service.DeploymentParamParseException;
import uk.org.ogsadai.service.MessageContextException;
import uk.org.ogsadai.service.MissingDeploymentParamException;
import uk.org.ogsadai.service.MissingPerformDocException;
import uk.org.ogsadai.service.OGSADAIConstants;
import uk.org.ogsadai.service.ResourceFileException;
import uk.org.ogsadai.service.authorization.AccessAuthorizer;
import uk.org.ogsadai.service.authorization.AuthorizationFactory;
import uk.org.ogsadai.service.authorization.AuthorizationInitialisationException;
import uk.org.ogsadai.service.authorization.ResourceAuthorizationException;
import uk.org.ogsadai.service.faults.AuthorisationFaultType;
import uk.org.ogsadai.service.faults.ComplexFaultType;
import uk.org.ogsadai.service.faults.InternalFaultType;
import uk.org.ogsadai.service.faults.RequestFaultType;
import uk.org.ogsadai.service.faults.ResourceBusyFaultType;
import uk.org.ogsadai.service.faults.ResourceUnknownFaultType;
import uk.org.ogsadai.service.perform.types.Perform;
import uk.org.ogsadai.service.perform.types.PerformResponse;
import uk.org.ogsadai.service.perform.types.Terminate;
import uk.org.ogsadai.service.perform.types.TerminateResponse;
import uk.org.ogsadai.service.resource.DataServiceResource;
import uk.org.ogsadai.service.resource.NoSuchResourceIDException;
import uk.org.ogsadai.service.resource.ResourceCreationException;
import uk.org.ogsadai.service.resource.ResourceIDAlreadyAssignedException;
import uk.org.ogsadai.service.resource.ResourceKeyInvalidException;
import uk.org.ogsadai.service.resource.ResourceRequestAuthorizationException;
import uk.org.ogsadai.service.resource.ResourceRequestExecutionException;
import uk.org.ogsadai.service.resource.ResourceRequestSpecificationException;
import uk.org.ogsadai.service.resource.ResourceUnknownException;
import uk.org.ogsadai.service.resource.config.ActivitiesConfig;
import uk.org.ogsadai.service.resource.config.DSRComponentFactory;
import uk.org.ogsadai.service.resource.config.FileBasedDSRComponentFactory;
import uk.org.ogsadai.service.resource.factory.DataServiceResourceFactory;
import uk.org.ogsadai.service.resource.factory.DataServiceResourceFactoryUtil;
import uk.org.ogsadai.service.resource.factory.DynamicDataServiceResourceCreationException;
import uk.org.ogsadai.service.resource.factory.DynamicDataServiceResourceRemovalException;
import uk.org.ogsadai.service.resource.factory.ResourceFactoryUtilCreateException;
import uk.org.ogsadai.service.transport.types.GetBlock;
import uk.org.ogsadai.service.transport.types.GetFully;
import uk.org.ogsadai.service.transport.types.GetNBlocks;
import uk.org.ogsadai.service.transport.types.GetResponse;
import uk.org.ogsadai.service.transport.types.PutBlock;
import uk.org.ogsadai.service.transport.types.PutFully;
import uk.org.ogsadai.service.transport.types.PutResponse;
import uk.org.ogsadai.service.types.GetVersion;
import uk.org.ogsadai.service.types.GetVersionResponse;
import uk.org.ogsadai.service.types.ListResources;
import uk.org.ogsadai.service.types.ListResourcesResponse;
import uk.org.ogsadai.service.wsrf.WSRFConstants;
import uk.org.ogsadai.service.wsrf.resource.DAIEPRConstructionException;
import uk.org.ogsadai.service.wsrf.resource.DAIResourceContextException;
import uk.org.ogsadai.service.wsrf.resource.DAIResourceException;
import uk.org.ogsadai.service.wsrf.resource.DataServiceResourceWrapper;
import uk.org.ogsadai.service.wsrf.resource.DataServiceResourceWrapperHome;
import uk.org.ogsadai.service.wsrf.sgr.DAIMDSRegistrationFailureException;
import uk.org.ogsadai.service.wsrf.sgr.ServiceGroupRegistrationClientWrapper;
import uk.org.ogsadai.sessions.SessionComponentFactory;
import uk.org.ogsadai.sessions.SessionStreamID;
import uk.org.ogsadai.types.ExtensibilityType;

public class DataServiceImpl
implements SecurityContextProvider,
DataServiceResourceFactory {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002-2006.";
    private static DAILogger LOG = DAILogger.getLogger((Class)DataServiceImpl.class);
    protected DataServiceResourceWrapperHome mResourceHome = null;
    private static final String RESOURCES_FILE = "dai.data.service.resources.file";
    protected String mResourcesFile = null;
    private static final String DAI_CONFIG_DIR = "dai.config.files.root";
    private String mConfigDir = null;
    private static final String DAI_SCHEMA_DIR = "dai.schema.files.root";
    private static final String VERSION = "dai.version";
    private static final String REQUEST_TIMEOUT = "dai.request.timeout";
    private static final String MAX_REQUESTS = "dai.max.requests";
    private static final String MAX_QUEUE_LENGTH = "dai.max.queue.length";
    private static final String AUTHORIZATION_CONFIG = "dai.authorization.config";
    private ConcurrencySettings mConcurrencySettings = new ConcurrencySettings(10, 20, 0L);
    protected static final String RESOURCE_ELT = "dataServiceResource";
    protected static final String RESOURCE_ATTR = "name";
    private String mVersion = null;
    protected String mURL = null;
    private AccessAuthorizer mAuthority = null;
    private ResourceContext mResourceContext = null;
    protected DataServiceResourceFactoryUtil mResourceFactoryUtil;

    public DataServiceImpl() throws InternalFaultType {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entering DataServiceImpl constructor.");
        }
        try {
            this.initialise();
        }
        catch (Exception e) {
            this.throwInternalFault(e, true);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exiting DataServiceImpl constructor.");
        }
    }

    private void initialise() throws MissingDeploymentParamException, MessageContextException, ResourceFileException, IllegalConcurrencySettingException, DeploymentParamParseException, ResourceFactoryUtilCreateException, AuthorizationInitialisationException {
        MessageContext context;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entered initialise...");
        }
        if ((context = MessageContext.getCurrentContext()) == null) {
            throw new MessageContextException();
        }
        this.mURL = context.getTargetService();
        this.mVersion = (String)context.getProperty(VERSION);
        this.mConfigDir = (String)context.getProperty(DAI_CONFIG_DIR);
        if (this.mConfigDir == null) {
            throw new MissingDeploymentParamException(DAI_CONFIG_DIR);
        }
        String schemaDir = (String)context.getProperty(DAI_SCHEMA_DIR);
        if (schemaDir == null) {
            throw new MissingDeploymentParamException(DAI_SCHEMA_DIR);
        }
        String resourcesFileStr = (String)context.getProperty(RESOURCES_FILE);
        if (resourcesFileStr == null || resourcesFileStr.equals("")) {
            throw new MissingDeploymentParamException(RESOURCES_FILE);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Service URL: " + this.mURL);
            LOG.debug("OGSA-DAI version: " + this.mVersion);
            LOG.debug("OGSA-DAI configuration file directory: " + this.mConfigDir);
            LOG.debug("OGSA-DAI schema directory: " + schemaDir);
            LOG.debug("OGSA-DAI data service resources file: " + resourcesFileStr);
        }
        this.configureConcurrencySettings(context);
        String authorizationFile = (String)context.getProperty(AUTHORIZATION_CONFIG);
        this.loadAuthorization(authorizationFile);
        try {
            this.mResourceContext = ResourceContext.getResourceContext();
            LOG.debug("Resource context is :" + this.mResourceContext.toString());
        }
        catch (ResourceContextException e) {
            DAIResourceContextException error = new DAIResourceContextException(e);
            LOG.error((Throwable)((Object)error));
        }
        try {
            this.mResourceFactoryUtil = new DataServiceResourceFactoryUtil(new File(this.mConfigDir), new File(schemaDir));
        }
        catch (DAIException e) {
            throw new ResourceFactoryUtilCreateException(e);
        }
        File resourcesFile = null;
        if (!this.mConfigDir.equals("")) {
            resourcesFile = new File(this.mConfigDir);
            resourcesFile = new File(resourcesFile, resourcesFileStr);
        } else {
            resourcesFile = new File(resourcesFileStr);
        }
        this.mResourcesFile = resourcesFile.toString();
        Document resourcesDoc = null;
        try {
            resourcesDoc = XMLUtilities.xmlFileToDOM((String)this.mResourcesFile, (boolean)false);
        }
        catch (DAIException e) {
            throw new ResourceFileException(resourcesFile, e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Data service resources file loaded.");
        }
        NodeList resources = resourcesDoc.getDocumentElement().getElementsByTagName(RESOURCE_ELT);
        int numResources = resources.getLength();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Number of resources: " + numResources);
        }
        for (int i = 0; i < numResources; ++i) {
            String name = ((Element)resources.item(i)).getAttribute(RESOURCE_ATTR);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating resource: " + i + " = " + name);
            }
            try {
                ResourceKey key = this.createResourceFromConfigDirectory(name);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Finshed creating resource: " + i + " = " + name);
                }
                this.registerResourceWithMDS(key);
                continue;
            }
            catch (DAIException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Failed to create resource: " + i + " = " + name);
                }
                LOG.error((Throwable)e);
            }
        }
    }

    private void configureConcurrencySettings(MessageContext context) throws DeploymentParamParseException, IllegalConcurrencySettingException {
        String maxRequestsStr = (String)context.getProperty(MAX_REQUESTS);
        String maxQueueLengthStr = (String)context.getProperty(MAX_QUEUE_LENGTH);
        String requestTimeoutStr = (String)context.getProperty(REQUEST_TIMEOUT);
        int maxRequests = this.mConcurrencySettings.getMaxRequests();
        int maxQueueLength = this.mConcurrencySettings.getMaxQueueLength();
        long requestTimeout = this.mConcurrencySettings.getRequestProcessingTimeout();
        if (maxRequestsStr != null) {
            try {
                maxRequests = Integer.valueOf(maxRequestsStr);
            }
            catch (NumberFormatException e) {
                throw new DeploymentParamParseException(MAX_REQUESTS, maxRequestsStr, Integer.class);
            }
        }
        if (maxQueueLengthStr != null) {
            try {
                maxQueueLength = Integer.valueOf(maxQueueLengthStr);
            }
            catch (NumberFormatException e) {
                throw new DeploymentParamParseException(MAX_QUEUE_LENGTH, maxQueueLengthStr, Integer.class);
            }
        }
        if (requestTimeoutStr != null) {
            try {
                requestTimeout = Long.valueOf(requestTimeoutStr);
            }
            catch (NumberFormatException e) {
                throw new DeploymentParamParseException(REQUEST_TIMEOUT, requestTimeoutStr, Long.class);
            }
        }
        try {
            this.mConcurrencySettings = new ConcurrencySettings(maxRequests, maxQueueLength, requestTimeout);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalConcurrencySettingException(maxRequests, maxQueueLength, requestTimeout);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("OGSA-DAI request timeout: " + requestTimeout);
            LOG.debug("OGSA-DAI maximum number of requests: " + maxRequests);
            LOG.debug("OGSA-DAI maximum queue length: " + maxQueueLength);
        }
    }

    public PerformResponse perform(Perform performDocument) throws RemoteException, ResourceBusyFaultType, ResourceUnknownFaultType, InternalFaultType, RequestFaultType, AuthorisationFaultType {
        DataServiceResource resource = this.getDataServiceResource();
        ExtensibilityType performDocExt = performDocument.getPerformDocument();
        MessageElement[] elts = performDocExt.get_any();
        if (elts.length < 1) {
            this.throwRequestFault((DAIException)new MissingPerformDocException());
        }
        Document performDoc = null;
        try {
            performDoc = elts[0].getAsDocument();
        }
        catch (Exception e) {
            this.throwInternalFault(e, false);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracted Perform document...");
        }
        AttachmentManager attMgr = new AttachmentManager();
        Document responseDoc = this.perform(resource, performDoc, attMgr);
        attMgr.addAttachments(MessageContext.getCurrentContext().getResponseMessage());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Wrapping Response document....");
        }
        ExtensibilityType responseType = new ExtensibilityType();
        MessageElement[] responseElts = new MessageElement[]{new MessageElement(responseDoc.getDocumentElement())};
        responseType.set_any(responseElts);
        PerformResponse response = new PerformResponse();
        response.setResult(responseType);
        return response;
    }

    private Document perform(DataServiceResource resource, Document performDoc, AttachmentManager attMgr) throws RemoteException, ResourceBusyFaultType, ResourceUnknownFaultType, InternalFaultType, RequestFaultType, AuthorisationFaultType {
        Document responseDoc = null;
        SecurityContext securityContext = this.getSecurityContext();
        RequestContext context = new RequestContext(securityContext);
        context.setDataServiceResourceFactory((DataServiceResourceFactory)this);
        context.setURL(this.mURL);
        context.setResourceID(resource.getID().toString());
        context.setAttachmentManager(attMgr);
        context.setAuthorizer(this.mAuthority);
        if (LOG.isInfoEnabled()) {
            LOG.info(MessageID.MSG_RECEIVED_CLIENT_RESOURCE_REQUEST, new Object[]{securityContext.getDN(), resource.getID()});
        }
        try {
            responseDoc = resource.perform(performDoc, context);
        }
        catch (ResourceRequestAuthorizationException e) {
            this.throwAuthorisationFault((DAIAuthorizationException)e);
        }
        catch (ResourceRequestExecutionException e) {
            this.throwInternalFault(e, false);
        }
        catch (ResourceRequestSpecificationException e) {
            this.throwRequestFault((DAIException)((Object)e));
        }
        catch (Exception e) {
            this.throwInternalFault(e, false);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info(MessageID.MSG_FORWARDED_CLIENT_RESOURCE_RESPONSE, new Object[]{securityContext.getDN(), resource.getID()});
        }
        return responseDoc;
    }

    public TerminateResponse terminate(Terminate terminate) throws RemoteException, ResourceBusyFaultType, ResourceUnknownFaultType, InternalFaultType, AuthorisationFaultType {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entered terminate...");
        }
        return new TerminateResponse();
    }

    public SecurityContext getSecurityContext() {
        GSSCredential credential = null;
        String callersDn = null;
        try {
            Subject subject = JaasSubject.getCurrentSubject();
            if (subject != null && (credential = JaasGssUtil.getCredential((Subject)subject)) != null) {
                callersDn = ((Object)credential.getName()).toString();
            }
        }
        catch (GSSException e) {
            GridCredentialAccessException ex = new GridCredentialAccessException((Throwable)e);
            LOG.warn((Throwable)ex);
        }
        if (callersDn == null) {
            callersDn = SecurityManager.getManager().getCaller();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Caller's DN is:  " + callersDn);
        }
        return new SecurityContext(callersDn, credential);
    }

    public ListResourcesResponse listResources(ListResources parameters) throws RemoteException, InternalFaultType {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entered listResources...");
        }
        DataServiceResourceWrapperHome home = null;
        try {
            home = this.getResourceHome();
        }
        catch (Exception e) {
            this.throwInternalFault(e, true);
        }
        String[] names = null;
        try {
            Object[] keys = home.getKeys();
            int numKeys = keys.length;
            names = new String[numKeys];
            for (int i = 0; i < numKeys; ++i) {
                names[i] = ((SimpleResourceKey)keys[i]).getValue().toString();
            }
        }
        catch (Exception e) {
            this.throwInternalFault(e, false);
        }
        ListResourcesResponse response = new ListResourcesResponse();
        response.setResource(names);
        return response;
    }

    public GetVersionResponse getVersion(GetVersion parameters) throws RemoteException, InternalFaultType {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entered getVersion...");
        }
        GetVersionResponse response = new GetVersionResponse();
        response.setVersion(this.mVersion);
        return response;
    }

    public PutResponse putFully(PutFully parameters) throws RemoteException, ResourceBusyFaultType, ResourceUnknownFaultType, InternalFaultType, RequestFaultType, AuthorisationFaultType {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entered putFully...");
        }
        SessionStreamID ssid = new SessionStreamID(parameters.getId());
        ExtensibilityType data = parameters.getData();
        DataServiceResource resource = this.getDataServiceResource();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Put data on " + ssid.getStreamID() + " stream of session " + ssid.getSessionID() + " of resource " + resource.getID());
        }
        Object block = null;
        try {
            block = SerializerUtils.toObject((MessageElement[])data.get_any());
        }
        catch (DAISerializationException e) {
            this.throwInternalFault(e, false);
        }
        try {
            resource.putFully(ssid, block);
        }
        catch (ResourceRequestAuthorizationException e) {
            this.throwAuthorisationFault((DAIAuthorizationException)e);
        }
        catch (ResourceRequestExecutionException e) {
            this.throwInternalFault(e, false);
        }
        catch (ResourceRequestSpecificationException e) {
            this.throwRequestFault((DAIException)((Object)e));
        }
        catch (Exception e) {
            this.throwInternalFault(e, false);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exiting putFully...");
        }
        return new PutResponse();
    }

    public PutResponse putBlock(PutBlock parameters) throws RemoteException, ResourceBusyFaultType, ResourceUnknownFaultType, InternalFaultType, RequestFaultType, AuthorisationFaultType {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entered putBlock...");
        }
        SessionStreamID ssid = new SessionStreamID(parameters.getId());
        ExtensibilityType data = parameters.getData();
        DataServiceResource resource = this.getDataServiceResource();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Put data on " + ssid.getStreamID() + " stream of session " + ssid.getSessionID() + " of resource " + resource.getID());
        }
        Object block = null;
        try {
            block = SerializerUtils.toObject((MessageElement[])data.get_any());
        }
        catch (DAISerializationException e) {
            this.throwInternalFault(e, false);
        }
        try {
            resource.putBlock(ssid, block);
        }
        catch (ResourceRequestAuthorizationException e) {
            this.throwAuthorisationFault((DAIAuthorizationException)e);
        }
        catch (ResourceRequestExecutionException e) {
            this.throwInternalFault(e, false);
        }
        catch (ResourceRequestSpecificationException e) {
            this.throwRequestFault((DAIException)((Object)e));
        }
        catch (Exception e) {
            this.throwInternalFault(e, false);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exiting putBlock...");
        }
        return new PutResponse();
    }

    public GetResponse getFully(GetFully parameters) throws RemoteException, ResourceBusyFaultType, ResourceUnknownFaultType, InternalFaultType, RequestFaultType, AuthorisationFaultType {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entered getFully...");
        }
        SessionStreamID ssid = new SessionStreamID(parameters.getId());
        DataServiceResource resource = this.getDataServiceResource();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get data from " + ssid.getStreamID() + " stream of session " + ssid.getSessionID() + " of resource " + resource.getID());
        }
        ExtensibilityType result = new ExtensibilityType();
        Object data = null;
        try {
            data = resource.getFully(ssid);
        }
        catch (ResourceRequestAuthorizationException e) {
            this.throwAuthorisationFault((DAIAuthorizationException)e);
        }
        catch (ResourceRequestExecutionException e) {
            this.throwInternalFault(e, false);
        }
        catch (ResourceRequestSpecificationException e) {
            this.throwRequestFault((DAIException)((Object)e));
        }
        catch (Exception e) {
            this.throwInternalFault(e, false);
        }
        result.set_any(SerializerUtils.toMessage((QName)OGSADAIConstants.DT_BLOCK_QNAME, (Object)data));
        data = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exiting getFully...");
        }
        GetResponse response = new GetResponse();
        response.setResult(result);
        return response;
    }

    public GetResponse getBlock(GetBlock parameters) throws RemoteException, ResourceBusyFaultType, ResourceUnknownFaultType, InternalFaultType, RequestFaultType, AuthorisationFaultType {
        GetNBlocks oneBlock = new GetNBlocks(parameters.getId(), 1);
        return this.getNBlocks(oneBlock);
    }

    public GetResponse getNBlocks(GetNBlocks parameters) throws RemoteException, ResourceBusyFaultType, ResourceUnknownFaultType, InternalFaultType, RequestFaultType, AuthorisationFaultType {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entered getNBlocks...");
        }
        SessionStreamID ssid = new SessionStreamID(parameters.getId());
        DataServiceResource resource = this.getDataServiceResource();
        int numberOfBlocks = parameters.getNumberOfBlocks();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get " + numberOfBlocks + " blocks of data from " + ssid.getStreamID() + " stream of session " + ssid.getSessionID() + " of resource " + resource.getID());
        }
        ExtensibilityType result = new ExtensibilityType();
        Object data = null;
        try {
            data = resource.getNBlocks(ssid, numberOfBlocks);
        }
        catch (ResourceRequestAuthorizationException e) {
            this.throwAuthorisationFault((DAIAuthorizationException)e);
        }
        catch (ResourceRequestExecutionException e) {
            this.throwInternalFault(e, false);
        }
        catch (ResourceRequestSpecificationException e) {
            this.throwRequestFault((DAIException)((Object)e));
        }
        catch (Exception e) {
            this.throwInternalFault(e, false);
        }
        result.set_any(SerializerUtils.toMessage((QName)OGSADAIConstants.DT_BLOCK_QNAME, (Object)data));
        data = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exiting getNBlocks...");
        }
        GetResponse response = new GetResponse();
        response.setResult(result);
        return response;
    }

    protected void throwRequestFault(DAIException e) throws RequestFaultType {
        LOG.warn((Throwable)e);
        RequestFaultType fault = new RequestFaultType();
        if (e instanceof DAIAuthorizationException) {
            this.addAuthzComplexFault((ComplexFaultType)fault, (DAIAuthorizationException)e);
            throw fault;
        }
        this.addComplexFault((ComplexFaultType)fault, e);
        Vector<ComplexFaultType> causesVector = new Vector<ComplexFaultType>();
        for (Throwable exception = e.getCause(); exception != null; exception = exception.getCause()) {
            ComplexFaultType complex = new ComplexFaultType();
            causesVector.add(complex);
            if (exception instanceof DAIAuthorizationException) {
                this.addAuthzComplexFault(complex, (DAIAuthorizationException)exception);
                break;
            }
            this.addComplexFault(complex, exception);
        }
        int numCauses = causesVector.size();
        ComplexFaultType[] causes = new ComplexFaultType[numCauses];
        for (int i = 0; i < numCauses; ++i) {
            causes[i] = (ComplexFaultType)causesVector.get(i);
        }
        fault.setReason(causes);
        throw fault;
    }

    private void addAuthzComplexFault(ComplexFaultType complex, DAIAuthorizationException exception) {
        AuthorisationFaultException authEx = new AuthorisationFaultException(exception);
        complex.setErrorID(authEx.getErrorID().toString());
        complex.setMsg(authEx.getLocalizedMessage());
        complex.setParams(new String[]{authEx.getParameters()[0].toString()});
    }

    private void addComplexFault(ComplexFaultType complex, Throwable exception) {
        DAIExceptionInformation daiEx = null;
        if (exception instanceof DAIExceptionInformation) {
            daiEx = (DAIExceptionInformation)exception;
        } else {
            NonOGSADAIExceptionWrapper wrapper = new NonOGSADAIExceptionWrapper(exception);
            daiEx = wrapper;
        }
        String errorID = daiEx.getErrorID().toString();
        Object[] params = daiEx.getParameters();
        String msg = exception.getLocalizedMessage();
        complex.setErrorID(errorID);
        complex.setMsg(msg);
        int numParams = 0;
        if (params != null) {
            numParams = params.length;
        }
        String[] stringParams = new String[numParams];
        for (int i = 0; i < numParams; ++i) {
            stringParams[i] = params[i].toString();
        }
        complex.setParams(stringParams);
    }

    protected void throwAuthorisationFault(DAIAuthorizationException exception) throws AuthorisationFaultType {
        LOG.warn((Throwable)exception);
        AuthorisationFaultException authEx = new AuthorisationFaultException(exception);
        throw new AuthorisationFaultType(authEx.getErrorID().toString(), authEx.getLocalizedMessage(), authEx.getParameters()[0].toString());
    }

    protected void throwResourceUnknownFault(String resourceID) throws ResourceUnknownFaultType {
        ResourceUnknownException ex = new ResourceUnknownException(resourceID);
        LOG.warn((Throwable)ex);
        throw new ResourceUnknownFaultType(ex.getErrorID().toString(), ex.getLocalizedMessage(), resourceID);
    }

    protected void throwInternalFault(Throwable exception, boolean isFatal) throws InternalFaultType {
        ServerException serverEx = new ServerException(exception);
        if (isFatal) {
            LOG.fatal((Throwable)serverEx, true);
        } else {
            LOG.error((Throwable)serverEx, true);
        }
        InternalFaultException internalEx = new InternalFaultException(serverEx);
        throw new InternalFaultType(internalEx.getErrorID().toString(), internalEx.getLocalizedMessage(), internalEx.getParameters()[0].toString());
    }

    protected DataServiceResourceWrapperHome getResourceHome() throws DAIResourceContextException {
        if (this.mResourceHome == null) {
            ResourceContext ctx = null;
            try {
                ctx = ResourceContext.getResourceContext();
                this.mResourceHome = (DataServiceResourceWrapperHome)ctx.getResourceHome();
            }
            catch (ResourceContextException e) {
                throw new DAIResourceContextException(e);
            }
        }
        return this.mResourceHome;
    }

    protected DataServiceResource getDataServiceResource() throws ResourceUnknownFaultType, InternalFaultType, AuthorisationFaultType {
        ResourceContext ctx = null;
        ResourceKey key = null;
        DataServiceResourceWrapper resource = null;
        try {
            ctx = ResourceContext.getResourceContext();
            key = ctx.getResourceKey();
            resource = (DataServiceResourceWrapper)ResourceContext.getResourceContext().getResource();
        }
        catch (NoSuchResourceException e) {
            this.throwResourceUnknownFault(key.getValue().toString());
        }
        catch (ResourceContextException e) {
            DAIResourceContextException ex = new DAIResourceContextException(e);
            this.throwInternalFault((Throwable)((Object)ex), true);
        }
        catch (ResourceException e) {
            DAIResourceException ex = new DAIResourceException(e);
            this.throwInternalFault((Throwable)((Object)ex), true);
        }
        DataServiceResource dataServiceResource = resource.getDataServiceResource();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found resource " + dataServiceResource.getID());
        }
        this.authorizeResource(dataServiceResource, this.getSecurityContext());
        return dataServiceResource;
    }

    protected ResourceKey createResourceFromConfigDirectory(Object id) throws ResourceIDAlreadyAssignedException, ResourceCreationException {
        FileBasedDSRComponentFactory componentFactory;
        try {
            componentFactory = new FileBasedDSRComponentFactory((Object)id.toString(), new File(this.mConfigDir));
        }
        catch (DAIException e) {
            throw new ResourceCreationException(id.toString(), e);
        }
        return this.createResourceFromComponentFactory(id, (DSRComponentFactory)componentFactory);
    }

    protected ResourceKey createResourceFromComponentFactory(Object id, DSRComponentFactory componentFactory) throws ResourceIDAlreadyAssignedException, ResourceCreationException {
        SessionComponentFactory sessionComponentFactory;
        DataResourceAccessor dataResourceAccessor;
        ActivitiesConfig activitiesConfig;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating componets for resource" + id.toString());
            }
            activitiesConfig = componentFactory.getActivityConfiguration();
            dataResourceAccessor = componentFactory.getDataResourceAccessor();
            sessionComponentFactory = componentFactory.getSessionComponentFactory();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created componets for resource" + id.toString());
            }
        }
        catch (DAIException e) {
            throw new ResourceCreationException(id.toString(), e);
        }
        return this.createResourceFromComponents(id, dataResourceAccessor, activitiesConfig, sessionComponentFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceKey createResourceFromComponents(Object id, DataResourceAccessor dataResourceAccessor, ActivitiesConfig activitiesConfig, SessionComponentFactory sessionComponentFactory) throws ResourceIDAlreadyAssignedException, ResourceCreationException {
        try {
            DataServiceResourceWrapperHome home = this.getResourceHome();
            SimpleResourceKey newKey = new SimpleResourceKey(WSRFConstants.DATA_SERVICE_RESOURCE_KEY, id);
            DataServiceResourceWrapperHome dataServiceResourceWrapperHome = home;
            synchronized (dataServiceResourceWrapperHome) {
                if (home.contains((ResourceKey)newKey)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Key " + newKey.toString() + " for id " + id + " already exists");
                    }
                    throw new ResourceIDAlreadyAssignedException(id);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Creating resource for id: " + id);
                }
                ResourceKey key = home.create(id, dataResourceAccessor, activitiesConfig, sessionComponentFactory, this, this.mConcurrencySettings, this.mAuthority);
                if (LOG.isInfoEnabled()) {
                    LOG.info(MessageID.MSG_DEPLOYED_DATA_SERVICE_RESOURCE, new Object[]{id});
                }
                return key;
            }
        }
        catch (DAIResourceContextException e) {
            throw new ResourceCreationException(id.toString(), (DAIException)e);
        }
        catch (ResourceKeyInvalidException e) {
            throw new ResourceCreationException(id.toString(), (DAIException)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeResource(Object id) throws NoSuchResourceIDException, ResourceKeyInvalidException, DAIResourceContextException {
        DataServiceResourceWrapperHome home = this.getResourceHome();
        SimpleResourceKey key = new SimpleResourceKey(WSRFConstants.DATA_SERVICE_RESOURCE_KEY, id);
        DataServiceResourceWrapperHome dataServiceResourceWrapperHome = home;
        synchronized (dataServiceResourceWrapperHome) {
            if (!home.contains((ResourceKey)key)) {
                throw new NoSuchResourceIDException((Object)key.getValue().toString());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found resource " + key.getValue().toString());
            }
            try {
                home.remove((ResourceKey)key);
                if (LOG.isInfoEnabled()) {
                    LOG.info(MessageID.MSG_UNDEPLOYED_DATA_SERVICE_RESOURCE, new Object[]{key});
                }
            }
            catch (NoSuchResourceException e) {
                throw new NoSuchResourceIDException((Object)key.getValue().toString());
            }
            catch (InvalidResourceKeyException e) {
                throw new ResourceKeyInvalidException((Object)key);
            }
            catch (RemoveNotSupportedException e) {
            }
            catch (ResourceException e) {
                // empty catch block
            }
        }
    }

    public String getNewResourceName() {
        return this.mResourceFactoryUtil.getNewResourceName();
    }

    public String getNewResourceName(String prefix) {
        return this.mResourceFactoryUtil.getNewResourceName(prefix);
    }

    public File getResourceConfigDirectory(String resourceName) throws DynamicDataServiceResourceCreationException {
        try {
            return this.mResourceFactoryUtil.createResourceConfigDirectory(resourceName);
        }
        catch (DAIException e) {
            throw new DynamicDataServiceResourceCreationException(resourceName, (Throwable)e);
        }
    }

    public void createResource(String resourceName, String dataResourceClassName) throws DynamicDataServiceResourceCreationException {
        try {
            this.mResourceFactoryUtil.writeClassConfigFile(resourceName, dataResourceClassName);
            this.mResourceFactoryUtil.replaceTokensInAllConfigFiles(resourceName);
            ResourceKey key = this.createResourceFromConfigDirectory(resourceName);
            this.registerResourceWithMDS(key);
            this.mResourceFactoryUtil.persistResource(resourceName, new File(this.mResourcesFile));
        }
        catch (DAIException e) {
            throw new DynamicDataServiceResourceCreationException(resourceName, (Throwable)e);
        }
    }

    public void removeResource(String resourceName, boolean removeConfiguration) throws DynamicDataServiceResourceRemovalException {
        try {
            this.removeResource(resourceName);
            this.mResourceFactoryUtil.removePersistentResource(resourceName, new File(this.mResourcesFile));
            if (removeConfiguration) {
                this.mResourceFactoryUtil.removeResourceConfigDirectory(resourceName);
            }
        }
        catch (DAIException e) {
            throw new DynamicDataServiceResourceRemovalException(resourceName, (Throwable)e);
        }
    }

    public String createResource(String namePrefix, DataResourceAccessor dataResourceAccessor, ActivitiesConfig activitiesConfig, SessionComponentFactory sessionComponentFactory) throws ResourceCreationException {
        String name = this.mResourceFactoryUtil.getNewResourceName(namePrefix);
        try {
            ResourceKey resourceKey = this.createResourceFromComponents(name, dataResourceAccessor, activitiesConfig, sessionComponentFactory);
            dataResourceAccessor.setResourceName(resourceKey.toString());
            return name;
        }
        catch (ResourceIDAlreadyAssignedException e) {
            throw new ResourceCreationException(name, (DAIException)((Object)e));
        }
    }

    public void registerResourceWithMDS(ResourceKey resourceKey) {
        String friendlyResourceName = resourceKey.getValue().toString();
        File resourceConfigDir = new File(this.mConfigDir, friendlyResourceName);
        File registrationFile = new File(resourceConfigDir, "mds-registration.xml");
        String registrationFilePath = registrationFile.getAbsolutePath();
        int index = registrationFilePath.lastIndexOf("/etc/");
        String relativeRegFileName = null;
        if (index != -1) {
            relativeRegFileName = registrationFilePath.substring(index);
        }
        if (registrationFile.exists() && relativeRegFileName != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using registration file: " + registrationFilePath);
                LOG.debug("Registering " + friendlyResourceName + " to MDS");
            }
            try {
                EndpointReferenceType epr;
                try {
                    epr = AddressingUtils.createEndpointReference((ResourceContext)this.mResourceContext, (ResourceKey)resourceKey);
                }
                catch (Exception e) {
                    throw new DAIEPRConstructionException(this.mResourceContext, friendlyResourceName);
                }
                ServiceGroupRegistrationClientWrapper.register(this.mResourceContext, epr, relativeRegFileName);
            }
            catch (Exception e) {
                DAIMDSRegistrationFailureException error = new DAIMDSRegistrationFailureException(friendlyResourceName, e);
                LOG.warn((Throwable)((Object)error));
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not find registration file: " + registrationFilePath);
                LOG.debug("Not Registering " + friendlyResourceName + " to MDS");
            }
            DAIFileNotFoundException fileNotFoundEx = new DAIFileNotFoundException(registrationFile);
            DAIMDSRegistrationFailureException error = new DAIMDSRegistrationFailureException(friendlyResourceName, (Throwable)fileNotFoundEx);
            LOG.warn((Throwable)((Object)error));
        }
    }

    private void loadAuthorization(String configFile) throws AuthorizationInitialisationException {
        this.mAuthority = AuthorizationFactory.createAuthorization((String)configFile);
    }

    private void authorizeResource(DataServiceResource resource, SecurityContext context) throws AuthorisationFaultType {
        if (!this.mAuthority.authorizeResource(resource.getID().toString(), context)) {
            this.throwAuthorisationFault((DAIAuthorizationException)new ResourceAuthorizationException(context.getDN(), resource.getID().toString()));
        }
    }
}

