/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.service.wsrf.dataservice.impl;

import java.io.File;
import java.rmi.RemoteException;
import org.globus.wsrf.ResourceKey;
import org.w3c.dom.Document;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.exception.DAIException;
import uk.org.ogsadai.service.ResourceFileException;
import uk.org.ogsadai.service.config.types.Deploy;
import uk.org.ogsadai.service.config.types.DeployResponse;
import uk.org.ogsadai.service.config.types.Undeploy;
import uk.org.ogsadai.service.config.types.UndeployResponse;
import uk.org.ogsadai.service.faults.AuthorisationFaultType;
import uk.org.ogsadai.service.faults.InternalFaultType;
import uk.org.ogsadai.service.faults.RequestFaultType;
import uk.org.ogsadai.service.faults.ResourceBusyFaultType;
import uk.org.ogsadai.service.faults.ResourceUnknownFaultType;
import uk.org.ogsadai.service.resource.NoSuchResourceIDException;
import uk.org.ogsadai.service.resource.PersistResourceNameFileException;
import uk.org.ogsadai.service.resource.RemoveResourceNameFileException;
import uk.org.ogsadai.service.resource.ResourceCreationException;
import uk.org.ogsadai.service.resource.ResourceIDAlreadyAssignedException;
import uk.org.ogsadai.service.wsrf.dataservice.impl.DataServiceImpl;

public class ConfigurableDataServiceImpl
extends DataServiceImpl {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2006.";
    private static DAILogger LOG = DAILogger.getLogger((Class)ConfigurableDataServiceImpl.class);

    public DeployResponse deploy(Deploy deploy) throws RemoteException, RequestFaultType, InternalFaultType, AuthorisationFaultType {
        String newID = deploy.getResourceID();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entered deploy...");
            LOG.debug("New data service resource ID: " + newID);
        }
        try {
            ResourceKey key = super.createResourceFromConfigDirectory(newID);
            super.registerResourceWithMDS(key);
        }
        catch (ResourceIDAlreadyAssignedException e) {
            super.throwRequestFault((DAIException)((Object)e));
        }
        catch (ResourceCreationException e) {
            super.throwRequestFault((DAIException)((Object)e));
        }
        catch (Exception e) {
            super.throwInternalFault(e, false);
        }
        File file = new File(this.mResourcesFile);
        Document resourcesDoc = null;
        try {
            resourcesDoc = XMLUtilities.xmlFileToDOM((String)this.mResourcesFile, (boolean)false);
        }
        catch (DAIException e) {
            ResourceFileException ex = new ResourceFileException(file, e);
            super.throwInternalFault((Throwable)ex, false);
        }
        catch (Exception e) {
            super.throwInternalFault(e, false);
        }
        try {
            this.mResourceFactoryUtil.persistResource(newID, new File(this.mResourcesFile));
        }
        catch (PersistResourceNameFileException e) {
            super.throwInternalFault(e, false);
        }
        catch (Exception e) {
            super.throwInternalFault(e, false);
        }
        return new DeployResponse();
    }

    public UndeployResponse undeploy(Undeploy deploy) throws RemoteException, ResourceBusyFaultType, ResourceUnknownFaultType, InternalFaultType, AuthorisationFaultType {
        String resourceID = deploy.getResourceID();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entered undeploy...");
            LOG.debug("Removing data service resource ID: " + resourceID);
        }
        try {
            super.removeResource(resourceID);
        }
        catch (NoSuchResourceIDException e) {
            super.throwResourceUnknownFault(resourceID);
        }
        catch (Exception e) {
            super.throwInternalFault(e, false);
        }
        try {
            this.mResourceFactoryUtil.removePersistentResource(resourceID, new File(this.mResourcesFile));
        }
        catch (RemoveResourceNameFileException e) {
            super.throwInternalFault(e, false);
        }
        catch (Exception e) {
            super.throwInternalFault(e, false);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exiting undeploy.");
        }
        return new UndeployResponse();
    }
}

