/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.delivery.wsrf;

import org.globus.wsrf.impl.security.authorization.HostAuthorization;
import org.globus.wsrf.impl.security.authorization.IdentityAuthorization;
import org.globus.wsrf.impl.security.authorization.NoAuthorization;
import org.globus.wsrf.impl.security.authorization.SelfAuthorization;
import org.globus.wsrf.security.Constants;
import org.ietf.jgss.GSSCredential;
import uk.org.ogsadai.client.toolkit.security.SecurityProperty;
import uk.org.ogsadai.client.toolkit.security.wsrf.GSIAuthorizationType;
import uk.org.ogsadai.client.toolkit.security.wsrf.GSIIdentityAuthorizationType;
import uk.org.ogsadai.client.toolkit.security.wsrf.GSIProtectionLevel;
import uk.org.ogsadai.client.toolkit.service.SOAPCallFactory;
import uk.org.ogsadai.common.msgs.DAILogger;

public class GSISecureConversationProperty
extends SecurityProperty {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2006.";
    private static final DAILogger LOG = DAILogger.getLogger((Class)GSISecureConversationProperty.class);
    private GSSCredential mCredential = null;
    private GSIProtectionLevel mProtectionLevel = GSIProtectionLevel.INTEGRITY;
    private GSIAuthorizationType mAuthorizationType = GSIAuthorizationType.HOST;

    public void setCredential(GSSCredential credential) {
        this.mCredential = credential;
    }

    public void setProtectionLevel(GSIProtectionLevel protectionLevel) {
        this.mProtectionLevel = protectionLevel;
    }

    public void setAuthorization(GSIAuthorizationType authzType) {
        this.mAuthorizationType = authzType;
    }

    public GSIProtectionLevel getProtectionLevel() {
        return this.mProtectionLevel;
    }

    public GSIAuthorizationType getAuthorizationType() {
        return this.mAuthorizationType;
    }

    public void configureCallFactory(SOAPCallFactory factory) {
        LOG.debug("Setting security to encryption");
        if (this.mCredential != null) {
            factory.setDefaultProperty("org.globus.gsi.credentials", (Object)this.mCredential);
        }
        Integer protectionLevel = null;
        protectionLevel = this.mProtectionLevel == GSIProtectionLevel.INTEGRITY ? Constants.SIGNATURE : Constants.ENCRYPTION;
        factory.setDefaultProperty("org.globus.security.secConv.msg.type", (Object)protectionLevel);
        HostAuthorization authorizationSetting = null;
        if (this.mAuthorizationType == GSIAuthorizationType.HOST) {
            authorizationSetting = HostAuthorization.getInstance();
        } else if (this.mAuthorizationType == GSIAuthorizationType.NONE) {
            authorizationSetting = NoAuthorization.getInstance();
        } else if (this.mAuthorizationType == GSIAuthorizationType.SELF) {
            authorizationSetting = SelfAuthorization.getInstance();
        } else if (this.mAuthorizationType instanceof GSIIdentityAuthorizationType) {
            GSIIdentityAuthorizationType identityAuthzType = (GSIIdentityAuthorizationType)this.mAuthorizationType;
            authorizationSetting = new IdentityAuthorization(identityAuthzType.getIdentity());
        }
        if (authorizationSetting != null) {
            factory.setDefaultProperty("org.globus.security.authorization", (Object)authorizationSetting);
        }
    }
}

