/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.delivery.wsrf;

import java.io.IOException;
import java.io.OutputStream;
import org.globus.io.streams.GridFTPOutputStream;
import org.ietf.jgss.GSSCredential;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.NoGridCredentialException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLDocumentException;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.exception.DAIIOException;
import uk.org.ogsadai.exception.DAINumberFormatException;
import uk.org.ogsadai.exception.DAIOutOfBoundsException;

public class DeliverToGFTPActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002-2006. (c) University of Edinburgh 2002-2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)DeliverToGFTPActivity.class);
    private BlockReader mInput;
    private GridFTPOutputStream mGFTPOutputStream = null;
    private String mHost = null;
    private int mPort;
    private String mFile = null;
    private GSSCredential mCredentials;
    private boolean mAppend;

    public DeliverToGFTPActivity(Element element) throws ActivityCreationException, ActivitySpecificationException {
        super(element);
        NodeList fromLocalList = element.getElementsByTagName("fromLocal");
        NodeList toGFTPList = element.getElementsByTagName("toGFTP");
        NamedNodeMap fromLocalAttributes = fromLocalList.item(0).getAttributes();
        String fromLocalActivityName = fromLocalAttributes.getNamedItem("from").getNodeValue();
        NamedNodeMap toGFTPAttributes = toGFTPList.item(0).getAttributes();
        this.mHost = toGFTPAttributes.getNamedItem("host").getNodeValue();
        String port = toGFTPAttributes.getNamedItem("port").getNodeValue();
        try {
            this.mPort = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            throw new ActivitySpecificationException(this.getName(), "port", (Throwable)new DAINumberFormatException(port));
        }
        if (this.mPort < 0) {
            throw new ActivitySpecificationException(this.getName(), "port", (Throwable)new DAIOutOfBoundsException(this.mPort, 0));
        }
        this.mFile = toGFTPAttributes.getNamedItem("file").getNodeValue();
        String appendAttribute = toGFTPAttributes.getNamedItem("append").getNodeValue();
        this.mAppend = appendAttribute.equals("true");
        this.mInternalInputs = new String[]{fromLocalActivityName};
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setup delivery toGFTP with host: " + this.mHost + ", port: " + this.mPort + ", file: " + this.mFile + ", fromLocal with from: " + fromLocalActivityName);
        }
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        super.initialise();
        try {
            this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
        this.mCredentials = this.mContext.getSecurityContext().getCredential();
        if (this.mCredentials == null) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)new NoGridCredentialException());
        }
    }

    public void processFirst() {
        try {
            this.mGFTPOutputStream = new GridFTPOutputStream(this.mCredentials, this.mHost, this.mPort, this.mFile, this.mAppend);
        }
        catch (Exception e) {
            this.setError(new ActivitySpecificationException(this.getName(), (Throwable)e));
        }
    }

    public void processBlock() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processBlock: start");
        }
        try {
            try {
                while (this.mInput.hasNext()) {
                    Object currentObject = this.mInput.next();
                    if (currentObject instanceof String) {
                        this.mGFTPOutputStream.write(((String)currentObject).getBytes());
                        continue;
                    }
                    if (currentObject instanceof byte[]) {
                        this.mGFTPOutputStream.write((byte[])currentObject);
                        continue;
                    }
                    if (currentObject instanceof Node) {
                        XMLUtilities.xmlDOMToStream((Node)((Node)currentObject), (OutputStream)this.mGFTPOutputStream);
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Delivering Object.toString() as type is unknown");
                    }
                    this.mGFTPOutputStream.write(currentObject.toString().getBytes());
                }
                this.setCompleted();
                this.mGFTPOutputStream.flush();
                this.mGFTPOutputStream.close();
            }
            catch (XMLDocumentException e) {
                throw new ActivitySpecificationException(this.getName(), (Throwable)e);
            }
            catch (XMLParseException e) {
                throw new ActivityExecutionException(this.getName(), (Throwable)e);
            }
            catch (IOException e) {
                throw new ActivityExecutionException(this.getName(), (Throwable)new DAIIOException(e));
            }
            catch (Exception e) {
                throw new ActivityExecutionException(this.getName(), (Throwable)e);
            }
        }
        catch (ActivitySpecificationException e) {
            this.setError(e);
        }
        catch (ActivityExecutionException e) {
            this.setError(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("processBlock: end");
        }
    }
}

