/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.delivery.wsrf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.globus.io.streams.GridFTPInputStream;
import org.ietf.jgss.GSSCredential;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.NoGridCredentialException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.exception.DAIIOException;
import uk.org.ogsadai.exception.DAINumberFormatException;
import uk.org.ogsadai.exception.DAIOutOfBoundsException;

public class DeliverFromGFTPActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002-2006. (c) University of Edinburgh 2002-2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)DeliverFromGFTPActivity.class);
    private BlockWriter mOutput;
    private GridFTPInputStream mGFTPInputStream = null;
    private String mHost = null;
    private int mPort;
    private String mFile = null;
    private GSSCredential mCredentials;

    public DeliverFromGFTPActivity(Element element) throws ActivityCreationException, ActivitySpecificationException {
        super(element);
        NodeList fromGFTPList = element.getElementsByTagName("fromGFTP");
        NodeList toLocalList = element.getElementsByTagName("toLocal");
        NamedNodeMap fromGFTPAttributes = fromGFTPList.item(0).getAttributes();
        this.mHost = fromGFTPAttributes.getNamedItem("host").getNodeValue();
        String port = fromGFTPAttributes.getNamedItem("port").getNodeValue();
        try {
            this.mPort = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            throw new ActivitySpecificationException(this.getName(), "port", (Throwable)new DAINumberFormatException(port));
        }
        if (this.mPort < 0) {
            throw new ActivitySpecificationException(this.getName(), "port", (Throwable)new DAIOutOfBoundsException(this.mPort, 0));
        }
        this.mFile = fromGFTPAttributes.getNamedItem("file").getNodeValue();
        NamedNodeMap toLocalAttributes = toLocalList.item(0).getAttributes();
        String toLocalActivityName = toLocalAttributes.getNamedItem("name").getNodeValue();
        this.mInternalOutputs = new String[]{toLocalActivityName};
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setup delivery fromGFTP with host: " + this.mHost + ", port: " + this.mPort + ", file: " + this.mFile + ", toLocal with to: " + toLocalActivityName);
        }
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        super.initialise();
        try {
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
        this.mCredentials = this.mContext.getSecurityContext().getCredential();
        if (this.mCredentials == null) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)new NoGridCredentialException());
        }
    }

    public void processFirst() {
        try {
            this.mGFTPInputStream = new GridFTPInputStream(this.mCredentials, this.mHost, this.mPort, this.mFile);
        }
        catch (Exception e) {
            this.setError((Throwable)new ActivitySpecificationException(this.getName(), (Throwable)e));
        }
    }

    public void processBlock() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processBlock: start");
        }
        byte[] buffer = new byte[4096];
        int bytesRead = 0;
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
        try {
            while ((bytesRead = this.mGFTPInputStream.read(buffer)) != -1) {
                byteBuffer.write(buffer, 0, bytesRead);
            }
            this.mGFTPInputStream.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Writing buffer of contents of GFTP to the block writer - " + byteBuffer.size() + " bytes");
                LOG.debug("Writing buffer of contents of GFTP to the block writer - '" + new String(byteBuffer.toByteArray()) + "'");
            }
            this.mOutput.put((Object)byteBuffer.toByteArray());
            byteBuffer.close();
            byteBuffer = null;
            this.mOutput.close();
            this.setCompleted();
        }
        catch (IOException e) {
            this.setError((Throwable)new ActivityExecutionException(this.getName(), (Throwable)new DAIIOException(e)));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("processBlock: end");
        }
    }
}

