/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.delivery.wsrf;

import java.net.MalformedURLException;
import org.ietf.jgss.GSSCredential;
import org.w3c.dom.Element;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.delivery.AbstractDeliverFromDTActivity;
import uk.org.ogsadai.activity.delivery.wsrf.DataTransportSecurityHelper;
import uk.org.ogsadai.activity.delivery.wsrf.GSISecureConversationProperty;
import uk.org.ogsadai.client.toolkit.ConnectionProperty;
import uk.org.ogsadai.client.toolkit.GenericServiceFetcher;
import uk.org.ogsadai.client.toolkit.exception.AuthorisationException;
import uk.org.ogsadai.client.toolkit.exception.RequestException;
import uk.org.ogsadai.client.toolkit.exception.ResourceUnknownException;
import uk.org.ogsadai.client.toolkit.exception.ServiceCommsException;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.service.ServiceTypeException;
import uk.org.ogsadai.client.toolkit.sessions.SessionStreamID;
import uk.org.ogsadai.common.NoGridCredentialException;
import uk.org.ogsadai.common.SecurityContext;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.exception.DAIMalformedURLException;

public class DeliverFromGDTActivity
extends AbstractDeliverFromDTActivity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)DeliverFromGDTActivity.class);
    private DataService mServiceStub = null;
    private GSISecureConversationProperty mSecurityProperties = null;

    public DeliverFromGDTActivity(Element activity) throws ActivityCreationException, ActivitySpecificationException {
        super(activity);
        this.mSecurityProperties = DataTransportSecurityHelper.parse(activity);
    }

    protected Object getFully() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            return this.mServiceStub.getFully();
        }
        catch (AuthorisationException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
        catch (RequestException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
        catch (ServiceCommsException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
        catch (ResourceUnknownException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
        catch (Exception e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
    }

    protected Object getNBlocks(int numBlocks) throws ActivitySpecificationException, ActivityExecutionException {
        try {
            return this.mServiceStub.getNBlocks(numBlocks);
        }
        catch (AuthorisationException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
        catch (RequestException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
        catch (ServiceCommsException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
        catch (ResourceUnknownException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
        catch (Exception e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
    }

    protected void contactTargetService() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            GenericServiceFetcher fetcher = GenericServiceFetcher.getInstance();
            this.mServiceStub = super.isServiceWSRF() ? fetcher.getWSRFDataService(this.mServiceURL, this.mResourceID) : (super.isServiceWSI() ? fetcher.getWSIDataService(this.mServiceURL, this.mResourceID) : fetcher.getDataService(this.mServiceURL, this.mResourceID));
            SessionStreamID id = new SessionStreamID(this.mStreamID);
            this.mServiceStub.setSessionStreamID(id);
            if (this.mSecurityProperties != null) {
                SecurityContext securityContext = this.mContext.getSecurityContext();
                GSSCredential credential = securityContext.getCredential();
                if (credential == null) {
                    throw new NoGridCredentialException();
                }
                this.mSecurityProperties.setCredential(credential);
                this.mServiceStub.setConnectionProperty((ConnectionProperty)this.mSecurityProperties);
            }
        }
        catch (MalformedURLException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)new DAIMalformedURLException(this.mServiceURL));
        }
        catch (NoGridCredentialException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
        catch (ServiceCommsException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
        catch (ServiceTypeException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
        catch (Exception e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
    }
}

