/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.delivery.wsrf;

import org.w3c.dom.Element;
import uk.org.ogsadai.activity.delivery.wsrf.GSISecureConversationProperty;
import uk.org.ogsadai.client.toolkit.security.wsrf.GSIAuthorizationType;
import uk.org.ogsadai.client.toolkit.security.wsrf.GSIIdentityAuthorizationType;
import uk.org.ogsadai.client.toolkit.security.wsrf.GSIProtectionLevel;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class DataTransportSecurityHelper {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2006";

    public static GSISecureConversationProperty parse(Element activityParameters) {
        if (activityParameters == null) {
            return null;
        }
        Element gsiSecureConvElement = XMLUtilities.getChildElement((Element)activityParameters, (String)"http://ogsadai.org.uk/namespaces/2005/10/types", (String)"GSISecureConversation");
        if (gsiSecureConvElement == null) {
            return null;
        }
        GSIProtectionLevel protectionLevel = DataTransportSecurityHelper.getProtectionLevel(gsiSecureConvElement);
        GSIAuthorizationType authzType = DataTransportSecurityHelper.getAuthorizationType(gsiSecureConvElement);
        GSISecureConversationProperty result = new GSISecureConversationProperty();
        if (protectionLevel != null) {
            result.setProtectionLevel(protectionLevel);
        }
        if (authzType != null) {
            result.setAuthorization(authzType);
        }
        return result;
    }

    private static GSIProtectionLevel getProtectionLevel(Element gsiSecureConvElement) {
        GSIProtectionLevel protectionLevel = null;
        String protectionLevelValue = gsiSecureConvElement.getAttribute("protectionLevel");
        if (protectionLevelValue.equals("integrity")) {
            protectionLevel = GSIProtectionLevel.INTEGRITY;
        } else if (protectionLevelValue.equals("privacy")) {
            protectionLevel = GSIProtectionLevel.PRIVACY;
        }
        return protectionLevel;
    }

    private static GSIAuthorizationType getAuthorizationType(Element gsiSecureConvElement) {
        Object authzType = null;
        String authzValue = gsiSecureConvElement.getAttribute("authorization");
        if (authzValue != null) {
            authzType = authzValue.equalsIgnoreCase("host") ? GSIAuthorizationType.HOST : (authzValue.equalsIgnoreCase("none") ? GSIAuthorizationType.NONE : (authzValue.equalsIgnoreCase("self") ? GSIAuthorizationType.SELF : new GSIIdentityAuthorizationType(authzValue)));
        }
        return authzType;
    }
}

