/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.sessions.impl;

import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.properties.Properties;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.dataresource.DataResourceAccessor;
import uk.org.ogsadai.exception.DAIClassCreateException;
import uk.org.ogsadai.exception.DAIClassNotFoundException;
import uk.org.ogsadai.exception.DAIException;
import uk.org.ogsadai.sessions.SessionAttrCreationException;
import uk.org.ogsadai.sessions.SessionAttrValueCreationException;
import uk.org.ogsadai.sessions.SessionAttributeValue;
import uk.org.ogsadai.sessions.SessionManager;
import uk.org.ogsadai.sessions.SessionManagerCreationException;
import uk.org.ogsadai.sessions.SessionManagerFactory;
import uk.org.ogsadai.sessions.impl.SessionConfiguration;
import uk.org.ogsadai.sessions.impl.StaticSessionAttribute;
import uk.org.ogsadai.sessions.impl.TransientSessionConfiguration;
import uk.org.ogsadai.sessions.impl.TransientSessionManager;

public class TransientSessionManagerFactory
implements SessionManagerFactory {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private static final DAILogger LOG = DAILogger.getLogger(TransientSessionManagerFactory.class);

    public SessionManager createSessionManager(Element configuration, Properties properties, DataResourceAccessor dataResource) throws SessionManagerCreationException {
        long defaultTimeout;
        if (configuration == null) {
            throw new IllegalArgumentException("configuration must not be null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties must not be null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating TransientSessionManager");
        }
        defaultTimeout = (defaultTimeout = XMLUtilities.parseLong(configuration, "timeout", "default")) == -1L ? -1L : defaultTimeout;
        long maxTimeout = XMLUtilities.parseLong(configuration, "timeout", "max");
        long l = maxTimeout = maxTimeout == -1L ? -1L : maxTimeout;
        if (maxTimeout != -1L && defaultTimeout > maxTimeout) {
            defaultTimeout = maxTimeout;
        }
        TransientSessionManager mgr = null;
        try {
            Set attributes = this.parseAttributes(configuration);
            SessionConfiguration config = this.createConfiguration(defaultTimeout, maxTimeout, attributes, properties, dataResource);
            mgr = new TransientSessionManager(config);
        }
        catch (DAIException e) {
            throw new SessionManagerCreationException(e);
        }
        return mgr;
    }

    private Set parseAttributes(Element parent) throws SessionAttrCreationException {
        HashSet<StaticSessionAttribute> attributes = new HashSet<StaticSessionAttribute>();
        NodeList children = parent.getElementsByTagName("sessionAttribute");
        for (int i = 0; i < children.getLength(); ++i) {
            Element attributeElement = (Element)children.item(i);
            StaticSessionAttribute attribute = this.createAttribute(attributeElement);
            attributes.add(attribute);
        }
        return attributes;
    }

    private StaticSessionAttribute createAttribute(Element attributeElement) throws SessionAttrCreationException {
        StaticSessionAttribute attribute = null;
        QName name = new QName(attributeElement.getAttribute("name"));
        String className = attributeElement.getAttribute("impl");
        try {
            Class<?> attributeClass = Class.forName(className);
            SessionAttributeValue value = (SessionAttributeValue)attributeClass.newInstance();
            value.initialise(attributeElement);
            attribute = new StaticSessionAttribute(name, value);
        }
        catch (ClassNotFoundException e) {
            throw new SessionAttrCreationException(name, (Throwable)new DAIClassNotFoundException(className));
        }
        catch (InstantiationException e) {
            throw new SessionAttrCreationException(name, (Throwable)new DAIClassCreateException(className, e));
        }
        catch (IllegalAccessException e) {
            throw new SessionAttrCreationException(name, (Throwable)new DAIClassCreateException(className, e));
        }
        catch (SessionAttrValueCreationException e) {
            throw new SessionAttrCreationException(name, (Throwable)e);
        }
        return attribute;
    }

    protected SessionConfiguration createConfiguration(long defaultTimeout, long maxTimeout, Set attributes, Properties properties, DataResourceAccessor dataResource) {
        return new TransientSessionConfiguration(defaultTimeout, maxTimeout, attributes, properties, dataResource);
    }
}

