/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.sessions.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.msgs.MessageID;
import uk.org.ogsadai.common.properties.CallbackSelfNotifyingProperty;
import uk.org.ogsadai.engine.MaxRequestTimeoutException;
import uk.org.ogsadai.service.resource.ResourceEvent;
import uk.org.ogsadai.sessions.InternalSession;
import uk.org.ogsadai.sessions.Session;
import uk.org.ogsadai.sessions.SessionCreationException;
import uk.org.ogsadai.sessions.SessionID;
import uk.org.ogsadai.sessions.SessionLookupException;
import uk.org.ogsadai.sessions.SessionManager;
import uk.org.ogsadai.sessions.SessionNames;
import uk.org.ogsadai.sessions.SessionNotFoundException;
import uk.org.ogsadai.sessions.SessionSettings;
import uk.org.ogsadai.sessions.SessionTerminationException;
import uk.org.ogsadai.sessions.SessionViewCreationException;
import uk.org.ogsadai.sessions.impl.SafeSession;
import uk.org.ogsadai.sessions.impl.SessionConfiguration;
import uk.org.ogsadai.sessions.impl.SessionRequestStatusPropertyValue;
import uk.org.ogsadai.sessions.impl.TransientInternalSession;

public class TransientSessionManager
implements SessionManager {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private static final DAILogger LOG = DAILogger.getLogger(TransientSessionManager.class);
    private final Map mSessions = Collections.synchronizedMap(new HashMap());
    private final SessionConfiguration mConfig;

    public TransientSessionManager(SessionConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        this.mConfig = config;
    }

    public boolean hasSession(SessionID sid) {
        if (sid == null) {
            throw new IllegalArgumentException("sid must not be null");
        }
        boolean found = false;
        if (this.mSessions.containsKey(sid)) {
            found = true;
        }
        return found;
    }

    public synchronized InternalSession newSession() throws SessionCreationException {
        SessionSettings settings = new SessionSettings(this.mConfig.getDefaultTimeout());
        TransientInternalSession session = new TransientInternalSession(settings, this.mConfig.getStaticSessionAttributes(), this.mConfig.getResourceProperties());
        this.addSession(session);
        return session;
    }

    public synchronized InternalSession newSession(SessionSettings settings) throws SessionCreationException {
        if (settings == null) {
            throw new IllegalArgumentException("settings must not be null");
        }
        if (this.mConfig.getMaxTimeout() != -1L && settings.getTimeout() > this.mConfig.getMaxTimeout()) {
            MaxRequestTimeoutException e = new MaxRequestTimeoutException(settings.getTimeout(), this.mConfig.getMaxTimeout());
            throw new SessionCreationException(e);
        }
        TransientInternalSession session = new TransientInternalSession(settings, this.mConfig.getStaticSessionAttributes(), this.mConfig.getResourceProperties());
        this.addSession(session);
        return session;
    }

    public synchronized InternalSession lookupSession(SessionID sid) throws SessionNotFoundException, SessionLookupException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looking up session: " + sid);
        }
        if (sid == null) {
            throw new IllegalArgumentException("sid must not be null");
        }
        if (!this.hasSession(sid)) {
            throw new SessionNotFoundException(sid);
        }
        InternalSession session = (InternalSession)this.mSessions.get(sid);
        return session;
    }

    public Session createSessionView(SessionID sid) throws SessionNotFoundException, SessionLookupException, SessionViewCreationException {
        if (sid == null) {
            throw new IllegalArgumentException("sid must not be null");
        }
        return new SafeSession(this.lookupSession(sid));
    }

    public synchronized void terminateSession(SessionID sid) throws SessionNotFoundException, SessionLookupException, SessionTerminationException {
        InternalSession session = this.lookupSession(sid);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Terminating session: " + sid);
            LOG.debug("Dispatching \"session terminated\" event.");
        }
        ResourceEvent event = new ResourceEvent(this, session);
        this.mConfig.getDispatcher().sessionTerminated(event);
        this.mSessions.remove(session.getID());
        session.cleanUp();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing session request status resource property");
        }
        QName propertyName = SessionNames.createStatusResourcePropertyName(session.getID());
        this.mConfig.getResourceProperties().remove(propertyName);
        if (LOG.isInfoEnabled()) {
            LOG.info(MessageID.MSG_SESSION_TERMINATED, new Object[]{session.getID()});
        }
    }

    private void addSession(InternalSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding new session to session map: " + session.getID());
        }
        this.mSessions.put(session.getID(), session);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating new session request status resource property");
        }
        QName propertyName = SessionNames.createStatusResourcePropertyName(session.getID());
        CallbackSelfNotifyingProperty statusProperty = new CallbackSelfNotifyingProperty(propertyName, session.getRequestStatus(), new SessionRequestStatusPropertyValue(session));
        this.mConfig.getResourceProperties().put(statusProperty);
        if (LOG.isInfoEnabled()) {
            LOG.info(MessageID.MSG_SESSION_CREATED, new Object[]{session.getID()});
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Dispatching \"session created\" event.");
        }
        ResourceEvent event = new ResourceEvent(this, session);
        this.mConfig.getDispatcher().sessionCreated(event);
        if (LOG.isDebugEnabled()) {
            LOG.debug("New session has been added to map: " + session.getID());
        }
    }

    public SessionConfiguration getSessionConfiguration() {
        return this.mConfig;
    }
}

