/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.sessions.impl;

import java.util.Set;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.properties.Properties;
import uk.org.ogsadai.dataresource.DataResourceAccessor;
import uk.org.ogsadai.service.resource.ResourceEventDispatcher;
import uk.org.ogsadai.service.resource.ResourceListener;
import uk.org.ogsadai.sessions.impl.SessionConfiguration;

public class TransientSessionConfiguration
implements SessionConfiguration {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private static final DAILogger LOG = DAILogger.getLogger(TransientSessionConfiguration.class);
    private final long mDefaultTimeout;
    private final long mMaxTimeout;
    private final Set mStaticAttributes;
    private final Properties mProperties;
    private final ResourceEventDispatcher mDispatcher;

    public TransientSessionConfiguration(long defaultTimeout, long maxTimeout, Set attributes, Properties properties, DataResourceAccessor dataResource) {
        if (LOG.isDebugEnabled()) {
            String message = "Creating a new TransientSessionManagerConfiguration object with the following settings:\n  Default timeout: " + defaultTimeout + "\n  Maximum timeout: " + maxTimeout + "\n  Static session attributes: " + attributes + "\n  Resource properties: " + properties;
            LOG.debug(message);
        }
        this.mDefaultTimeout = defaultTimeout;
        this.mMaxTimeout = maxTimeout;
        this.mStaticAttributes = attributes;
        this.mProperties = properties;
        this.mDispatcher = new ResourceEventDispatcher();
        if (dataResource instanceof ResourceListener) {
            this.mDispatcher.addListener((ResourceListener)((Object)dataResource));
        }
    }

    public long getDefaultTimeout() {
        return this.mDefaultTimeout;
    }

    public long getMaxTimeout() {
        return this.mMaxTimeout;
    }

    public Set getStaticSessionAttributes() {
        return this.mStaticAttributes;
    }

    public Properties getResourceProperties() {
        return this.mProperties;
    }

    public ResourceEventDispatcher getDispatcher() {
        return this.mDispatcher;
    }
}

