/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.sessions.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import uk.org.ogsadai.sessions.Session;
import uk.org.ogsadai.sessions.SessionAttribute;
import uk.org.ogsadai.sessions.SessionID;
import uk.org.ogsadai.sessions.StaticSessionAttrException;

public abstract class TransientSession
implements Session {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private final Map mAttributes = Collections.synchronizedMap(new HashMap());

    public abstract SessionID getID();

    public synchronized boolean containsAttribute(QName name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        return this.mAttributes.containsKey(name);
    }

    public synchronized int countAttributes() {
        return this.mAttributes.size();
    }

    public synchronized SessionAttribute getAttribute(QName name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        SessionAttribute property = null;
        if (this.mAttributes.containsKey(name)) {
            property = (SessionAttribute)this.mAttributes.get(name);
        }
        return property;
    }

    public synchronized Set getAttributeNames() {
        return this.mAttributes.keySet();
    }

    public synchronized Object getAttributeValue(QName name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        Object value = null;
        if (this.mAttributes.containsKey(name)) {
            value = this.getAttribute(name).getValue();
        }
        return value;
    }

    public synchronized void removeAttribute(QName name) throws StaticSessionAttrException {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.ensureChangeable(name);
        this.mAttributes.remove(name);
    }

    public synchronized void setAttribute(SessionAttribute property) throws StaticSessionAttrException {
        if (property == null) {
            throw new IllegalArgumentException("property must not be null");
        }
        this.ensureChangeable(property.getName());
        this.mAttributes.put(property.getName(), property);
    }

    private void ensureChangeable(QName name) throws StaticSessionAttrException {
        SessionAttribute attribute = this.getAttribute(name);
        if (attribute != null && !attribute.isChangable()) {
            throw new StaticSessionAttrException(name);
        }
    }

    public void cleanUp() {
        Iterator i = this.getAttributeNames().iterator();
        while (i.hasNext()) {
            QName name = (QName)i.next();
            this.mAttributes.remove(name);
        }
    }
}

