/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.sessions.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.properties.Properties;
import uk.org.ogsadai.engine.Pipe;
import uk.org.ogsadai.engine.ProcessingStatus;
import uk.org.ogsadai.sessions.InternalSession;
import uk.org.ogsadai.sessions.MaxSessionParticipantsException;
import uk.org.ogsadai.sessions.SessionAttribute;
import uk.org.ogsadai.sessions.SessionCreationException;
import uk.org.ogsadai.sessions.SessionEvent;
import uk.org.ogsadai.sessions.SessionEventDispatcher;
import uk.org.ogsadai.sessions.SessionID;
import uk.org.ogsadai.sessions.SessionJoinDeniedException;
import uk.org.ogsadai.sessions.SessionJoinException;
import uk.org.ogsadai.sessions.SessionListener;
import uk.org.ogsadai.sessions.SessionParticipant;
import uk.org.ogsadai.sessions.SessionSettings;
import uk.org.ogsadai.sessions.SessionStreamDuplicateException;
import uk.org.ogsadai.sessions.StaticSessionAttrException;
import uk.org.ogsadai.sessions.impl.TransientSession;

public class TransientInternalSession
extends TransientSession
implements InternalSession {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private static final DAILogger LOG = DAILogger.getLogger(TransientInternalSession.class);
    private final SessionEventDispatcher mDispatcher = new SessionEventDispatcher();
    private SessionParticipant mParticipant;
    private final SessionSettings mSettings;
    private final Properties mProperties;
    private final ProcessingStatus mStatus;
    private final Map mExternalOutputs = new HashMap();
    private final Map mExternalInputs = new HashMap();

    public TransientInternalSession(SessionSettings settings, Set attributes, Properties properties) throws SessionCreationException {
        if (settings == null) {
            throw new IllegalArgumentException("settings must not be null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties must not be null");
        }
        this.mSettings = settings;
        this.mProperties = properties;
        this.mStatus = new ProcessingStatus(this);
        if (attributes != null) {
            Iterator i = attributes.iterator();
            while (i.hasNext()) {
                SessionAttribute attribute = (SessionAttribute)i.next();
                try {
                    this.setAttribute(attribute);
                }
                catch (StaticSessionAttrException e) {
                    throw new SessionCreationException(e);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new session with the following settings:");
            LOG.debug(this.mSettings.toString());
        }
    }

    public void addSessionListener(SessionListener listener) {
        this.mDispatcher.addSessionListener(listener);
    }

    public synchronized void admit(SessionParticipant participant) throws SessionJoinDeniedException, SessionJoinException {
        if (participant == null) {
            throw new IllegalArgumentException("participant must not be null");
        }
        if (this.mParticipant == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Participant joined to session.");
            }
        } else {
            throw new SessionJoinDeniedException(new MaxSessionParticipantsException(1));
        }
        this.mParticipant = participant;
        this.mDispatcher.sessionJoined(new SessionEvent(this, participant));
    }

    public synchronized void cleanUp() {
        super.cleanUp();
        this.mDispatcher.sessionCleanedUp(new SessionEvent(this));
    }

    public synchronized int countParticants() {
        return this.mParticipant == null ? 0 : 1;
    }

    public SessionID getID() {
        return this.mSettings.getSessionID();
    }

    public SessionSettings getSettings() {
        return this.mSettings;
    }

    public synchronized void release(SessionParticipant participant) {
        if (participant == null) {
            throw new IllegalArgumentException("participant must not be null");
        }
        if (this.mParticipant == participant) {
            this.mParticipant = null;
            this.mDispatcher.sessionLeft(new SessionEvent(this, participant));
        }
    }

    public String toString() {
        return this.getID().toString();
    }

    public Properties getProperties() {
        return this.mProperties;
    }

    public ProcessingStatus getRequestStatus() {
        return this.mStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addExternalInput(String name, Pipe input) throws SessionStreamDuplicateException {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        Map map = this.mExternalInputs;
        synchronized (map) {
            if (this.hasExternalInput(name)) {
                throw new SessionStreamDuplicateException(this.getID(), name);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding external input " + name + " to session " + this.getID());
            }
            this.mExternalInputs.put(name, input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExternalOutput(String name, Pipe output) throws SessionStreamDuplicateException {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        Map map = this.mExternalOutputs;
        synchronized (map) {
            if (this.hasExternalOutput(name)) {
                throw new SessionStreamDuplicateException(this.getID(), name);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding external output " + name + " to session " + this.getID());
            }
            this.mExternalOutputs.put(name, output);
        }
    }

    public boolean hasExternalInput(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        return this.mExternalInputs.containsKey(name);
    }

    public boolean hasExternalOutput(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        return this.mExternalOutputs.containsKey(name);
    }

    public Pipe getExternalOutput(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        return (Pipe)this.mExternalOutputs.get(name);
    }

    public Pipe getExternalInput(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        return (Pipe)this.mExternalInputs.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExternalInput(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        Map map = this.mExternalInputs;
        synchronized (map) {
            if (this.hasExternalInput(name)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Removing external input: " + name);
                }
                this.mExternalInputs.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExternalOutput(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        Map map = this.mExternalOutputs;
        synchronized (map) {
            if (this.hasExternalOutput(name)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Removing external output: " + name);
                }
                this.mExternalOutputs.remove(name);
            }
        }
    }
}

