/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.sessions.impl;

import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.exception.DAIException;
import uk.org.ogsadai.sessions.InternalSession;
import uk.org.ogsadai.sessions.SessionCreationException;
import uk.org.ogsadai.sessions.SessionEvent;
import uk.org.ogsadai.sessions.SessionID;
import uk.org.ogsadai.sessions.SessionListener;
import uk.org.ogsadai.sessions.SessionLookupException;
import uk.org.ogsadai.sessions.SessionManager;
import uk.org.ogsadai.sessions.SessionNotFoundException;
import uk.org.ogsadai.sessions.SessionStrategy;

public class TerminateSessionStrategy
implements SessionStrategy {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private static final DAILogger LOG = DAILogger.getLogger(TerminateSessionStrategy.class);
    private final SessionID mSessionID;

    public TerminateSessionStrategy(SessionID sessionID) {
        if (sessionID == null) {
            throw new IllegalArgumentException("sessionID must not be null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating TerminateSessionStrategy");
        }
        this.mSessionID = sessionID;
    }

    public InternalSession obtainSession(SessionManager manager) throws SessionCreationException, SessionLookupException, SessionNotFoundException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Obtaining session from session manager: " + this.mSessionID);
        }
        InternalSession session = manager.lookupSession(this.mSessionID);
        session.addSessionListener(this.createSessionListener(manager));
        return session;
    }

    SessionListener createSessionListener(final SessionManager manager) {
        return new SessionListener(){
            private boolean mSessionAlive = true;

            public void sessionJoined(SessionEvent event) {
            }

            public synchronized void sessionLeft(SessionEvent event) {
                InternalSession session = event.getInternalSession();
                if (session.countParticants() == 0) {
                    SessionID sid = session.getID();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("About to terminate session: " + sid);
                    }
                    if (this.mSessionAlive) {
                        try {
                            manager.terminateSession(sid);
                        }
                        catch (DAIException e) {
                            LOG.error(e);
                        }
                    }
                }
            }

            public synchronized void sessionCleanedUp(SessionEvent event) {
                this.mSessionAlive = false;
            }
        };
    }
}

