/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.sessions.impl;

import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.sessions.InternalSession;
import uk.org.ogsadai.sessions.SessionCoordinator;
import uk.org.ogsadai.sessions.SessionCreationException;
import uk.org.ogsadai.sessions.SessionID;
import uk.org.ogsadai.sessions.SessionJoinDeniedException;
import uk.org.ogsadai.sessions.SessionJoinException;
import uk.org.ogsadai.sessions.SessionLookupException;
import uk.org.ogsadai.sessions.SessionManager;
import uk.org.ogsadai.sessions.SessionNotFoundException;
import uk.org.ogsadai.sessions.SessionParticipant;
import uk.org.ogsadai.sessions.SessionReleaseException;
import uk.org.ogsadai.sessions.SessionStrategy;

public class SimpleSessionCoordinator
implements SessionCoordinator {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private static final DAILogger LOG = DAILogger.getLogger(SimpleSessionCoordinator.class);
    private final SessionManager mSessionManager;

    public SimpleSessionCoordinator(SessionManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException("manager must not be null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Constructing SessionCoordinator that uses the following SessionManager implementation: " + manager.getClass());
        }
        this.mSessionManager = manager;
    }

    public synchronized void join(SessionParticipant participant) throws SessionNotFoundException, SessionJoinDeniedException, SessionJoinException {
        if (participant == null) {
            throw new IllegalArgumentException("participant must not be null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Joining participant to session...");
        }
        SessionStrategy strategy = participant.getSessionStrategy();
        try {
            InternalSession session = strategy.obtainSession(this.mSessionManager);
            session.admit(participant);
            participant.setSession(session);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Participant " + participant + " joined to session ID " + session);
            }
        }
        catch (SessionCreationException e) {
            throw new SessionJoinException(e);
        }
        catch (SessionLookupException e) {
            throw new SessionJoinException(e);
        }
    }

    public synchronized void release(SessionParticipant participant) throws SessionNotFoundException, SessionReleaseException {
        if (participant == null) {
            throw new IllegalArgumentException("participant must not be null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Releasing participant from session...");
        }
        SessionID sessionID = participant.getSession().getID();
        try {
            InternalSession session = this.mSessionManager.lookupSession(sessionID);
            session.release(participant);
        }
        catch (SessionLookupException e) {
            throw new SessionReleaseException(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Participant " + participant + " released from session ID " + sessionID);
        }
    }

    public SessionManager getSessionManager() {
        return this.mSessionManager;
    }
}

