/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.sessions.impl;

import java.util.Timer;
import java.util.TimerTask;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.exception.DAIException;
import uk.org.ogsadai.sessions.InternalSession;
import uk.org.ogsadai.sessions.SessionEvent;
import uk.org.ogsadai.sessions.SessionListener;
import uk.org.ogsadai.sessions.SessionManager;
import uk.org.ogsadai.sessions.SessionSettings;

public class SessionTerminator
implements SessionListener {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private static final DAILogger LOG = DAILogger.getLogger(SessionTerminator.class);
    private final Timer mTimer = new Timer();
    private TimerTask mTerminatorTask;
    private final SessionManager mManager;
    private boolean mSessionAlive = true;

    public SessionTerminator(SessionManager manager) {
        this.mManager = manager;
    }

    public synchronized void sessionJoined(SessionEvent event) {
        if (this.mTerminatorTask != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cancelling expiry timer for session " + event.getInternalSession());
            }
            boolean bl = this.mTerminatorTask.cancel();
        }
    }

    public synchronized void sessionLeft(SessionEvent event) {
        InternalSession session;
        if (this.mSessionAlive && (session = event.getInternalSession()).countParticants() == 0) {
            long timeout;
            SessionSettings settings = session.getSettings();
            long l = timeout = settings.hasTimeout() ? settings.getTimeout() : this.mManager.getSessionConfiguration().getDefaultTimeout();
            if (timeout == -1L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No default timeout settings specified, so terminating session " + session + " immediately.");
                }
                this.terminateSession(session);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Starting expiry timer for session " + session + " with timeout in " + timeout + "ms.");
                }
                this.mTerminatorTask = this.createTimerTask(session);
                this.mTimer.schedule(this.mTerminatorTask, timeout);
            }
        }
    }

    public synchronized void sessionCleanedUp(SessionEvent event) {
        this.mTimer.cancel();
        this.mSessionAlive = false;
    }

    private TimerTask createTimerTask(final InternalSession session) {
        return new TimerTask(){

            public void run() {
                SessionTerminator.this.terminateSession(session);
            }
        };
    }

    private void terminateSession(InternalSession session) {
        if (this.mSessionAlive) {
            try {
                this.mManager.terminateSession(session.getID());
            }
            catch (DAIException e) {
                LOG.error(e);
            }
        }
    }
}

