/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.sessions.impl;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.sessions.SessionID;
import uk.org.ogsadai.sessions.SessionSettings;
import uk.org.ogsadai.sessions.SessionStrategy;
import uk.org.ogsadai.sessions.SessionStrategyFactory;
import uk.org.ogsadai.sessions.impl.ExplicitSessionStrategy;
import uk.org.ogsadai.sessions.impl.ImplicitSessionStrategy;
import uk.org.ogsadai.sessions.impl.ReferenceSessionStrategy;
import uk.org.ogsadai.sessions.impl.TerminateSessionStrategy;

public class SessionStrategyFactoryImpl
implements SessionStrategyFactory {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";

    public SessionStrategy createSessionStrategy(Document document) {
        SessionStrategy strategy = null;
        Element root = document.getDocumentElement();
        NodeList nodes = root.getElementsByTagName("session");
        if (nodes.getLength() > 0) {
            Element sessionElement = (Element)nodes.item(0);
            strategy = this.createSessionStrategyFromElement(sessionElement);
        } else {
            strategy = new ImplicitSessionStrategy();
        }
        return strategy;
    }

    private SessionStrategy createSessionStrategyFromElement(Element sessionElement) {
        SessionStrategy strategy = null;
        if (sessionElement.hasAttribute("id")) {
            SessionID sid = new SessionID(sessionElement.getAttribute("id"));
            strategy = sessionElement.hasAttribute("mode") ? new TerminateSessionStrategy(sid) : new ReferenceSessionStrategy(sid);
        } else {
            long timeout = sessionElement.hasAttribute("timeout") ? Long.parseLong(sessionElement.getAttribute("timeout")) : -1L;
            strategy = new ExplicitSessionStrategy(new SessionSettings(timeout));
        }
        return strategy;
    }
}

