/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.sessions.impl;

import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.exception.DAIException;
import uk.org.ogsadai.sessions.InternalSession;
import uk.org.ogsadai.sessions.SessionCreationException;
import uk.org.ogsadai.sessions.SessionEvent;
import uk.org.ogsadai.sessions.SessionListener;
import uk.org.ogsadai.sessions.SessionLookupException;
import uk.org.ogsadai.sessions.SessionManager;
import uk.org.ogsadai.sessions.SessionNotFoundException;
import uk.org.ogsadai.sessions.SessionStrategy;

public class ImplicitSessionStrategy
implements SessionStrategy {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private static final DAILogger LOG = DAILogger.getLogger(ImplicitSessionStrategy.class);

    public InternalSession obtainSession(SessionManager manager) throws SessionCreationException, SessionLookupException, SessionNotFoundException {
        InternalSession session = manager.newSession();
        session.addSessionListener(this.createSessionListener(manager));
        return session;
    }

    SessionListener createSessionListener(final SessionManager manager) {
        return new SessionListener(){

            public void sessionJoined(SessionEvent event) {
            }

            public synchronized void sessionLeft(SessionEvent event) {
                InternalSession session = event.getInternalSession();
                if (session.countParticants() == 0) {
                    try {
                        manager.terminateSession(session.getID());
                    }
                    catch (DAIException e) {
                        LOG.error(e);
                    }
                }
            }

            public void sessionCleanedUp(SessionEvent event) {
            }
        };
    }
}

