/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.sessions;

import uk.org.ogsadai.activity.PipeAccessException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.SimpleBlockBuffer;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.engine.EngineConstants;
import uk.org.ogsadai.engine.Pipe;
import uk.org.ogsadai.sessions.Session;
import uk.org.ogsadai.sessions.SessionID;
import uk.org.ogsadai.sessions.SessionLookupException;
import uk.org.ogsadai.sessions.SessionManager;
import uk.org.ogsadai.sessions.SessionNotFoundException;
import uk.org.ogsadai.sessions.SessionStreamClosedException;
import uk.org.ogsadai.sessions.SessionStreamID;
import uk.org.ogsadai.sessions.SessionStreamIOException;
import uk.org.ogsadai.sessions.SessionStreamManager;
import uk.org.ogsadai.sessions.SessionStreamNotFoundException;
import uk.org.ogsadai.sessions.SessionStreamRequestNotProcessingException;

public class SimpleSessionStreamManager
implements SessionStreamManager {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private static final DAILogger LOG = DAILogger.getLogger(SimpleSessionStreamManager.class);
    private final SessionManager mManager;
    private static final int ALL_BLOCKS = 0;

    public SimpleSessionStreamManager(SessionManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException("manager must not be null");
        }
        this.mManager = manager;
    }

    public boolean hasSession(SessionID id) throws SessionLookupException {
        return this.mManager.hasSession(id);
    }

    public boolean hasInput(SessionStreamID id) throws SessionNotFoundException, SessionLookupException {
        boolean result = false;
        Session session = this.getSession(id.getSessionID());
        if (session.hasExternalInput(id.getStreamID())) {
            Pipe pipe = session.getExternalInput(id.getStreamID());
            result = pipe.isOpen();
        }
        return result;
    }

    public boolean hasOutput(SessionStreamID id) throws SessionNotFoundException, SessionLookupException {
        Session session = this.getSession(id.getSessionID());
        boolean result = session.hasExternalOutput(id.getStreamID());
        return result;
    }

    public Object getFully(SessionStreamID id) throws SessionNotFoundException, SessionLookupException, SessionStreamNotFoundException, SessionStreamRequestNotProcessingException, SessionStreamIOException {
        return this.getNBlocks(id, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNBlocks(SessionStreamID id, int numberOfBlocks) throws SessionNotFoundException, SessionLookupException, SessionStreamNotFoundException, SessionStreamRequestNotProcessingException, SessionStreamIOException {
        BlockReader reader = this.getBlockReader(id);
        SimpleBlockBuffer buffer = new SimpleBlockBuffer();
        boolean all = numberOfBlocks == 0;
        try {
            BlockReader blockReader = reader;
            synchronized (blockReader) {
                for (int i = 0; (all || i < numberOfBlocks) && reader.hasNext(); ++i) {
                    buffer.appendBlock(reader.next());
                }
            }
            if (buffer.size() == 0) {
                return EngineConstants.NO_MORE_DATA;
            }
            return buffer.toBlock();
        }
        catch (PipeAccessException e) {
            throw new SessionStreamRequestNotProcessingException(id);
        }
        catch (Exception e) {
            throw new SessionStreamIOException(id, (Throwable)e);
        }
    }

    public Object getBlock(SessionStreamID id) throws SessionNotFoundException, SessionLookupException, SessionStreamNotFoundException, SessionStreamRequestNotProcessingException, SessionStreamIOException {
        return this.getNBlocks(id, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBlock(SessionStreamID id, Object data) throws SessionNotFoundException, SessionLookupException, SessionStreamNotFoundException, SessionStreamRequestNotProcessingException, SessionStreamClosedException {
        BlockWriter writer = this.getBlockWriter(id);
        try {
            BlockWriter blockWriter = writer;
            synchronized (blockWriter) {
                if (data.equals(EngineConstants.NO_MORE_DATA) || data.equals(EngineConstants.NO_MORE_DATA.toString())) {
                    writer.close();
                } else {
                    try {
                        writer.put(data);
                    }
                    catch (IllegalStateException e) {
                        throw new SessionStreamClosedException(id);
                    }
                }
            }
        }
        catch (PipeAccessException cause) {
            throw new SessionStreamRequestNotProcessingException(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFully(SessionStreamID id, Object data) throws SessionNotFoundException, SessionLookupException, SessionStreamNotFoundException, SessionStreamRequestNotProcessingException, SessionStreamClosedException {
        BlockWriter writer = this.getBlockWriter(id);
        try {
            BlockWriter blockWriter = writer;
            synchronized (blockWriter) {
                try {
                    writer.put(data);
                }
                catch (IllegalStateException e) {
                    throw new SessionStreamClosedException(id);
                }
                writer.close();
            }
        }
        catch (PipeAccessException e) {
            throw new SessionStreamRequestNotProcessingException(id);
        }
    }

    private Session getSession(SessionID sessionID) throws SessionNotFoundException, SessionLookupException {
        return this.mManager.lookupSession(sessionID);
    }

    private BlockReader getBlockReader(SessionStreamID id) throws SessionNotFoundException, SessionLookupException, SessionStreamNotFoundException {
        Pipe reader = null;
        Session session = this.getSession(id.getSessionID());
        if (!session.hasExternalOutput(id.getStreamID())) {
            throw new SessionStreamNotFoundException(id);
        }
        reader = session.getExternalOutput(id.getStreamID());
        return reader;
    }

    private BlockWriter getBlockWriter(SessionStreamID id) throws SessionNotFoundException, SessionLookupException, SessionStreamNotFoundException {
        Pipe writer = null;
        Session session = this.getSession(id.getSessionID());
        if (!session.hasExternalInput(id.getStreamID())) {
            throw new SessionStreamNotFoundException(id);
        }
        writer = session.getExternalInput(id.getStreamID());
        return writer;
    }
}

