/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.sessions;

import uk.org.ogsadai.client.toolkit.sessions.Session;
import uk.org.ogsadai.sessions.SessionID;

public class SessionStreamID {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) The University of Edinburgh 2002 - 2005.";
    private SessionID mSessionID;
    private String mStreamID;
    public static final String SEPARATOR = ":";

    public SessionStreamID(SessionID sessionID, String streamID) {
        if (sessionID == null) {
            throw new IllegalArgumentException("sessionID must not be null");
        }
        if (streamID == null) {
            throw new IllegalArgumentException("streamID must not be null");
        }
        this.mSessionID = sessionID;
        this.mStreamID = streamID;
    }

    public SessionStreamID(Session session, String streamID) {
        if (session == null) {
            throw new IllegalArgumentException("session must not be null");
        }
        if (streamID == null) {
            throw new IllegalArgumentException("streamID must not be null");
        }
        this.mSessionID = new SessionID(session.getSessionID().toString());
        this.mStreamID = streamID;
    }

    public SessionStreamID(String compoundID) {
        if (compoundID == null || compoundID.length() < 3) {
            throw new IllegalArgumentException("compoundID must not be null");
        }
        int index = compoundID.indexOf(SEPARATOR);
        if (index <= 0 || index == compoundID.length() - 1 || compoundID.length() < 3) {
            throw new IllegalArgumentException("compoundID argument must be of the form sessionID:streamID");
        }
        this.mSessionID = new SessionID(compoundID.substring(0, index));
        this.mStreamID = compoundID.substring(index + 1);
    }

    public SessionID getSessionID() {
        return this.mSessionID;
    }

    public String getStreamID() {
        return this.mStreamID;
    }

    public String getCompoundID() {
        return this.mSessionID.toString() + SEPARATOR + this.mStreamID;
    }

    public String toString() {
        return this.getCompoundID();
    }
}

