/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.sessions;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import uk.org.ogsadai.sessions.SessionEvent;
import uk.org.ogsadai.sessions.SessionListener;

public class SessionEventDispatcher
implements SessionListener {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) The University of Edinburgh 2002 - 2005.";
    private final Collection mListeners = new HashSet();

    public synchronized void sessionJoined(SessionEvent event) {
        Iterator i = this.mListeners.iterator();
        while (i.hasNext()) {
            SessionListener listener = (SessionListener)i.next();
            listener.sessionJoined(event);
        }
    }

    public synchronized void sessionLeft(SessionEvent event) {
        Iterator i = this.mListeners.iterator();
        while (i.hasNext()) {
            SessionListener listener = (SessionListener)i.next();
            listener.sessionLeft(event);
        }
    }

    public synchronized void sessionCleanedUp(SessionEvent event) {
        Iterator i = this.mListeners.iterator();
        while (i.hasNext()) {
            SessionListener listener = (SessionListener)i.next();
            listener.sessionCleanedUp(event);
        }
    }

    public synchronized void addSessionListener(SessionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.mListeners.add(listener);
    }
}

