/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.sessions;

import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.common.files.DAIFileContentError;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.properties.Properties;
import uk.org.ogsadai.common.xml.XMLFileException;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.dataresource.DataResourceAccessor;
import uk.org.ogsadai.exception.DAIClassCreateException;
import uk.org.ogsadai.exception.DAIClassMissingInterfaceException;
import uk.org.ogsadai.exception.DAIClassNotFoundException;
import uk.org.ogsadai.exception.DAIException;
import uk.org.ogsadai.sessions.SessionComponentFactory;
import uk.org.ogsadai.sessions.SessionCoordinator;
import uk.org.ogsadai.sessions.SessionManager;
import uk.org.ogsadai.sessions.SessionManagerCreationException;
import uk.org.ogsadai.sessions.SessionManagerFactory;
import uk.org.ogsadai.sessions.SessionManagerFactoryCreationException;
import uk.org.ogsadai.sessions.impl.SimpleSessionCoordinator;

public class SessionConfigurationLoader
implements SessionComponentFactory {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private static final DAILogger LOG = DAILogger.getLogger(SessionConfigurationLoader.class);
    private final File mSessionConfigFile;
    private final Element mSessionConfig;
    private final SessionManagerFactory mSessionManagerFactory;
    private DataResourceAccessor mDataResourceAccessor;
    private Properties mResourceProperties;
    private boolean mAreComponentsBuilt;
    private SessionCoordinator mCoordinator;

    public SessionConfigurationLoader(File sessionConfigFile) throws SessionManagerFactoryCreationException {
        if (sessionConfigFile == null) {
            throw new IllegalArgumentException("sessionConfigFile must not be null");
        }
        this.mSessionConfigFile = sessionConfigFile;
        this.mAreComponentsBuilt = false;
        this.mSessionConfig = this.buildElement(sessionConfigFile);
        try {
            String className = this.parseFactoryClassName(this.mSessionConfig);
            this.mSessionManagerFactory = this.createSessionManagerFactory(className);
        }
        catch (SessionManagerFactoryCreationException e) {
            Throwable cause = e.getCause();
            DAIFileContentError fce = new DAIFileContentError(this.mSessionConfigFile, cause);
            throw new SessionManagerFactoryCreationException(fce);
        }
    }

    public void setDataResourceAccessor(DataResourceAccessor dataResourceAccessor) {
        if (dataResourceAccessor == null) {
            throw new IllegalArgumentException("dataResourceAccessor must not be null");
        }
        this.mDataResourceAccessor = dataResourceAccessor;
    }

    public void setResourceProperties(Properties resourceProperties) {
        if (resourceProperties == null) {
            throw new IllegalArgumentException("resourceProperties must not be null");
        }
        this.mResourceProperties = resourceProperties;
    }

    public SessionCoordinator getSessionCoordinator() throws DAIException {
        if (this.mDataResourceAccessor == null || this.mResourceProperties == null) {
            throw new IllegalStateException("setDataResourceAccessor and setResourceProperties methods must be called first");
        }
        this.buildComponents();
        return this.mCoordinator;
    }

    private void buildComponents() throws SessionManagerCreationException {
        if (!this.mAreComponentsBuilt) {
            try {
                SessionManager manager = this.mSessionManagerFactory.createSessionManager(this.mSessionConfig, this.mResourceProperties, this.mDataResourceAccessor);
                this.mCoordinator = new SimpleSessionCoordinator(manager);
                this.mAreComponentsBuilt = true;
            }
            catch (SessionManagerCreationException e) {
                Throwable cause = e.getCause();
                DAIFileContentError fce = new DAIFileContentError(this.mSessionConfigFile, cause);
                throw new SessionManagerCreationException(fce);
            }
        }
    }

    private Element buildElement(File sessionConfiguration) throws SessionManagerFactoryCreationException {
        Element element = null;
        try {
            Document document = XMLUtilities.xmlFileToDOM(sessionConfiguration.getAbsolutePath(), true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session configuration file:");
                LOG.debug(XMLUtilities.xmlDOMToString(document));
            }
            element = document.getDocumentElement();
        }
        catch (XMLParseException e) {
            DAIFileContentError fce = new DAIFileContentError(sessionConfiguration, (Throwable)e);
            throw new SessionManagerFactoryCreationException(fce);
        }
        catch (XMLFileException e) {
            throw new SessionManagerFactoryCreationException(e);
        }
        return element;
    }

    private String parseFactoryClassName(Element config) {
        String className = "";
        NodeList nodes = config.getElementsByTagName("sessionManagerFactory");
        if (nodes.getLength() > 0) {
            Element sessionManagerElement = (Element)nodes.item(0);
            className = sessionManagerElement.getAttribute("impl");
        }
        return className;
    }

    SessionManagerFactory createSessionManagerFactory(String className) throws SessionManagerFactoryCreationException {
        SessionManagerFactory factory = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading the following SessionManagerFactory: " + className);
        }
        try {
            Class<?> factoryClass = Class.forName(className);
            if (!SessionManagerFactory.class.isAssignableFrom(factoryClass)) {
                DAIClassMissingInterfaceException e = new DAIClassMissingInterfaceException(className, SessionManagerFactory.class.getName());
                throw new SessionManagerFactoryCreationException(e);
            }
            factory = (SessionManagerFactory)factoryClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new SessionManagerFactoryCreationException(new DAIClassNotFoundException(className));
        }
        catch (InstantiationException e) {
            throw new SessionManagerFactoryCreationException(new DAIClassCreateException(className, e));
        }
        catch (IllegalAccessException e) {
            throw new SessionManagerFactoryCreationException(new DAIClassCreateException(className, e));
        }
        return factory;
    }
}

