/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.service.resource.factory;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.common.UniqueName;
import uk.org.ogsadai.common.files.DAIDirectoryNotDirectoryException;
import uk.org.ogsadai.common.files.DAIDirectoryNotFoundException;
import uk.org.ogsadai.common.files.FileUtilities;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.exception.DAIException;
import uk.org.ogsadai.service.resource.DAIConfigDirectoryException;
import uk.org.ogsadai.service.resource.PersistResourceNameFileException;
import uk.org.ogsadai.service.resource.RemoveResourceNameFileException;
import uk.org.ogsadai.service.resource.factory.CreateResourceConfigDirectoryException;
import uk.org.ogsadai.service.resource.factory.CreateResourceConfigFileException;
import uk.org.ogsadai.service.resource.factory.CustomiseResourceConfigFileException;

public class DataServiceResourceFactoryUtil {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static DAILogger LOG = DAILogger.getLogger(DataServiceResourceFactoryUtil.class);
    private static String CLASS_CONFIG_FILENAME = "dataResourceClassConfig.xml";
    private static String CLASS_CONFIG_TEMPLATE_FILENAME = "dataResourceClassConfigTemplate.xml";
    private static String DATA_RESOURCE_ACCESSOR_CLASS_NAME_TOKEN = "%DATA_RESOURCE_ACCESSOR_CLASS_NAME%";
    private File mConfigDirectory;
    private Object mPersistResourceSynchronization = new Object();
    private File mSchemaDirectory;
    public static String OGSADAI_SCHEMA_ROOT_TOKEN = "%OGSADAI_SCHEMA_ROOT%";

    public DataServiceResourceFactoryUtil(File configDirectory, File schemaDirectory) throws DAIConfigDirectoryException {
        if (configDirectory == null) {
            throw new IllegalArgumentException("configDirectory must not be null");
        }
        if (!configDirectory.exists()) {
            DAIDirectoryNotFoundException ex = new DAIDirectoryNotFoundException(configDirectory);
            throw new DAIConfigDirectoryException(configDirectory, ex);
        }
        if (!configDirectory.isDirectory()) {
            DAIDirectoryNotDirectoryException ex = new DAIDirectoryNotDirectoryException(configDirectory);
            throw new DAIConfigDirectoryException(configDirectory, ex);
        }
        this.mConfigDirectory = configDirectory;
        this.mSchemaDirectory = schemaDirectory;
    }

    public String getNewResourceName() {
        return UniqueName.getInstance().getName();
    }

    public String getNewResourceName(String prefix) {
        return prefix + UniqueName.getInstance().getName();
    }

    public File createResourceConfigDirectory(String resourceName) throws CreateResourceConfigDirectoryException {
        File resourceDir = new File(this.mConfigDirectory, resourceName);
        try {
            if (!resourceDir.exists()) {
                resourceDir.mkdir();
            }
        }
        catch (Exception e) {
            throw new CreateResourceConfigDirectoryException(resourceName, e);
        }
        return resourceDir;
    }

    public void writeClassConfigFile(String resourceName, String className) throws CreateResourceConfigFileException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entered writeClassConfigFile(" + resourceName + ", " + className + ")");
        }
        String fileText = null;
        InputStream templateInputStream = this.getClass().getResourceAsStream(CLASS_CONFIG_TEMPLATE_FILENAME);
        try {
            fileText = FileUtilities.readStringFromStream(templateInputStream);
        }
        catch (Exception e) {
            throw new CreateResourceConfigFileException(resourceName, CLASS_CONFIG_FILENAME, e);
        }
        fileText = fileText.replaceAll(DATA_RESOURCE_ACCESSOR_CLASS_NAME_TOKEN, className);
        File resourceDir = new File(this.mConfigDirectory, resourceName);
        File classConfigFile = new File(resourceDir, CLASS_CONFIG_FILENAME);
        try {
            FileUtilities.replaceWriteStringToFile(classConfigFile.getAbsolutePath(), fileText);
        }
        catch (Exception e) {
            throw new CreateResourceConfigFileException(resourceName, CLASS_CONFIG_FILENAME, e);
        }
    }

    public void replaceTokensInAllConfigFiles(String resourceName) throws CustomiseResourceConfigFileException {
        File resourceDir = new File(this.mConfigDirectory, resourceName);
        HashMap<String, String> tokenMapping = new HashMap<String, String>();
        tokenMapping.put(OGSADAI_SCHEMA_ROOT_TOKEN, this.mSchemaDirectory.toURI().toString());
        try {
            FileUtilities.replaceTokensInDirectory(resourceDir, tokenMapping);
        }
        catch (Exception e) {
            throw new CustomiseResourceConfigFileException(resourceName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistResource(String resourceName, File resourcesFile) throws PersistResourceNameFileException {
        Object object = this.mPersistResourceSynchronization;
        synchronized (object) {
            try {
                Document resourcesDoc = XMLUtilities.xmlFileToDOM(resourcesFile.getAbsolutePath(), false);
                Element newResourceElement = resourcesDoc.createElement("dataServiceResource");
                newResourceElement.setAttribute("name", resourceName);
                NodeList resourcesElements = resourcesDoc.getElementsByTagName("dataServiceResources");
                resourcesElements.item(0).appendChild(newResourceElement);
                XMLUtilities.xmlDOMToFile(resourcesDoc, resourcesFile.getAbsolutePath());
            }
            catch (Exception e) {
                throw new PersistResourceNameFileException(resourceName, resourcesFile, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePersistentResource(String resourceName, File resourcesFile) throws RemoveResourceNameFileException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entering removePersistentResource, resource name = " + resourceName + ", file = " + resourcesFile);
        }
        Object object = this.mPersistResourceSynchronization;
        synchronized (object) {
            try {
                LOG.debug("Opening resources file");
                Document resourcesDoc = XMLUtilities.xmlFileToDOM(resourcesFile.getAbsolutePath(), false);
                NodeList resourceList = resourcesDoc.getElementsByTagName("dataServiceResource");
                LOG.debug("Searching for resource: " + resourceName);
                for (int i = 0; i < resourceList.getLength(); ++i) {
                    Element resourceElt = (Element)resourceList.item(i);
                    if (!resourceElt.getAttribute("name").equals(resourceName)) continue;
                    resourcesDoc.getDocumentElement().removeChild(resourceElt);
                    break;
                }
                LOG.debug("Writing resources file");
                XMLUtilities.xmlDOMToFile(resourcesDoc, resourcesFile.getAbsolutePath());
            }
            catch (DAIException e) {
                throw new RemoveResourceNameFileException(resourceName, resourcesFile, e);
            }
        }
        LOG.debug("Exiting removePersistentResource");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeResourceConfigDirectory(String resourceName) {
        Object object = this.mPersistResourceSynchronization;
        synchronized (object) {
            return FileUtilities.deleteDir(new File(this.mConfigDirectory, resourceName));
        }
    }
}

