/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.service.resource.config;

import java.io.File;
import uk.org.ogsadai.common.files.DAIDirectoryNotDirectoryException;
import uk.org.ogsadai.common.files.DAIDirectoryNotFoundException;
import uk.org.ogsadai.common.files.DAIFileNotFoundException;
import uk.org.ogsadai.common.files.FileUtilities;
import uk.org.ogsadai.dataresource.DataResourceAccessor;
import uk.org.ogsadai.dataresource.DataResourceAccessorFactory;
import uk.org.ogsadai.exception.DAIException;
import uk.org.ogsadai.service.resource.config.ActivitiesConfig;
import uk.org.ogsadai.service.resource.config.DSRComponentFactory;
import uk.org.ogsadai.service.resource.config.FileBasedActivitiesConfig;
import uk.org.ogsadai.sessions.SessionComponentFactory;
import uk.org.ogsadai.sessions.SessionConfigurationLoader;
import uk.org.ogsadai.sessions.SessionCoordinatorCreationException;

public class FileBasedDSRComponentFactory
implements DSRComponentFactory {
    private static final String COPYRIGHT_NOTICE = "(c) The University of Edinburgh 2002 - 2006.";
    protected final String ACTIVITY_CONFIG_FILENAME = "activityConfig.xml";
    protected final String SESSION_CONFIG_FILENAME = "sessionConfig.xml";
    protected final Object mResourceId;
    protected final File mResourceConfigDir;

    public FileBasedDSRComponentFactory(Object id, File topLevelConfigDir) throws DAIDirectoryNotFoundException, DAIDirectoryNotDirectoryException {
        if (id == null) {
            throw new IllegalArgumentException("id parameter cannot be null");
        }
        if (topLevelConfigDir == null) {
            throw new IllegalArgumentException("topLevelConfigDir parameter cannot be null");
        }
        if (!topLevelConfigDir.exists()) {
            throw new DAIDirectoryNotFoundException(topLevelConfigDir);
        }
        if (!topLevelConfigDir.isDirectory()) {
            throw new DAIDirectoryNotDirectoryException(topLevelConfigDir);
        }
        this.mResourceId = id;
        this.mResourceConfigDir = new File(topLevelConfigDir, id.toString());
        if (!this.mResourceConfigDir.exists()) {
            throw new DAIDirectoryNotFoundException(this.mResourceConfigDir);
        }
        if (!this.mResourceConfigDir.isDirectory()) {
            throw new DAIDirectoryNotDirectoryException(this.mResourceConfigDir);
        }
    }

    public ActivitiesConfig getActivityConfiguration() throws DAIException {
        File activityConfigFile = new File(this.mResourceConfigDir, "activityConfig.xml");
        return new FileBasedActivitiesConfig(activityConfigFile);
    }

    public DataResourceAccessor getDataResourceAccessor() throws DAIException {
        DataResourceAccessor dataResourceAccessor = DataResourceAccessorFactory.getInstance().createDataResourceAccessor(this.mResourceId.toString(), this.mResourceConfigDir);
        return dataResourceAccessor;
    }

    public SessionComponentFactory getSessionComponentFactory() throws DAIException {
        File sessionConfig = new File(this.mResourceConfigDir, "sessionConfig.xml");
        try {
            FileUtilities.fileExists(sessionConfig);
        }
        catch (DAIFileNotFoundException e) {
            throw new SessionCoordinatorCreationException(e);
        }
        SessionConfigurationLoader sessionCompFactory = new SessionConfigurationLoader(sessionConfig);
        return sessionCompFactory;
    }
}

