/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.service.resource.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.ActivityClassDocumentValidator;
import uk.org.ogsadai.activity.ActivityPropertyDocumentValidator;
import uk.org.ogsadai.activity.ConfigurableActivitiesDocumentValidator;
import uk.org.ogsadai.common.DocumentValidationException;
import uk.org.ogsadai.common.NetUtilities;
import uk.org.ogsadai.common.files.DAIFileContentError;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLFileException;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.common.xml.XMLSchemaUtilities;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.exception.DAIException;
import uk.org.ogsadai.exception.DAIMalformedURLException;
import uk.org.ogsadai.exception.DAIURLContentException;
import uk.org.ogsadai.exception.DAIURLReadIOException;
import uk.org.ogsadai.service.resource.config.ActivitiesConfig;
import uk.org.ogsadai.service.resource.config.ActivityConfig;
import uk.org.ogsadai.service.resource.config.BasicActivityConfig;

public class FileBasedActivitiesConfig
implements ActivitiesConfig {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    private static final DAILogger DAILOG = DAILogger.getLogger(FileBasedActivitiesConfig.class);
    private Document mBasePerformDocumentSchema;
    private ActivityConfig[] mActivities;

    public FileBasedActivitiesConfig(File configFile) throws DAIFileContentError, XMLFileException {
        if (configFile == null) {
            throw new IllegalArgumentException("The configFile parameter must not be null.");
        }
        Document doc = this.getConfigFileAsDocument(configFile);
        try {
            this.mActivities = this.getActivityConfigs(doc);
            this.mBasePerformDocumentSchema = this.getBasePerformDocumentSchema(doc);
        }
        catch (DAIException e) {
            throw new DAIFileContentError(configFile, (Throwable)e);
        }
    }

    public Document getBasePerformDocumentSchema() {
        return this.mBasePerformDocumentSchema;
    }

    public ActivityConfig[] getActivityConfigs() {
        return this.mActivities;
    }

    private Document getConfigFileAsDocument(File configFile) throws DAIFileContentError, XMLFileException {
        try {
            if (DAILOG.isDebugEnabled()) {
                DAILOG.debug("Loading activity configuration file from: " + configFile);
            }
            boolean VALIDATE = true;
            Document config = XMLUtilities.xmlFileToDOM(configFile.getAbsolutePath(), VALIDATE);
            ActivityClassDocumentValidator chain = new ActivityClassDocumentValidator();
            ConfigurableActivitiesDocumentValidator tail1 = new ConfigurableActivitiesDocumentValidator();
            ActivityPropertyDocumentValidator tail2 = new ActivityPropertyDocumentValidator();
            chain.setSuccessor(tail1);
            tail1.setSuccessor(tail2);
            chain.validate(config);
            return config;
        }
        catch (DocumentValidationException e) {
            throw new DAIFileContentError(configFile, (Throwable)e);
        }
        catch (XMLParseException e) {
            throw new DAIFileContentError(configFile, (Throwable)e);
        }
    }

    private ActivityConfig[] getActivityConfigs(Document configDoc) throws DAIMalformedURLException, DAIURLReadIOException, DAIURLContentException {
        ArrayList<ActivityConfig> list = new ArrayList<ActivityConfig>();
        NodeList activityMaps = configDoc.getDocumentElement().getElementsByTagName("activityMap");
        for (int i = 0; i < activityMaps.getLength(); ++i) {
            Element activityMap = (Element)activityMaps.item(i);
            String configBase = activityMap.getAttribute("configBase");
            String schemaBase = activityMap.getAttribute("schemaBase");
            NodeList activities = activityMap.getElementsByTagName("activity");
            for (int j = 0; j < activities.getLength(); ++j) {
                Element activity = (Element)activities.item(j);
                ActivityConfig activityConfig = this.getActivityConfig(activity, configBase, schemaBase);
                list.add(activityConfig);
            }
        }
        return list.toArray(new ActivityConfig[list.size()]);
    }

    private ActivityConfig getActivityConfig(Element activityElement, String configBase, String schemaBase) throws DAIMalformedURLException, DAIURLReadIOException, DAIURLContentException {
        NodeList nodes;
        Properties properties;
        Document schemaDoc;
        String name = activityElement.getAttribute("name");
        String implementation = activityElement.getAttribute("implementation");
        String schemaPath = activityElement.getAttribute("schema");
        if (schemaBase != null) {
            schemaPath = schemaBase + schemaPath;
        }
        try {
            schemaDoc = NetUtilities.readToDocument(schemaPath, false);
            XMLSchemaUtilities.makeSchemaLocationsAbsolute(schemaDoc, schemaPath);
        }
        catch (XMLParseException e) {
            throw new DAIURLContentException(schemaPath, e);
        }
        BasicActivityConfig result = new BasicActivityConfig(name, implementation, schemaDoc);
        if (activityElement.hasAttribute("config")) {
            String configPath = activityElement.getAttribute("config");
            if (configBase != null) {
                configPath = configBase + configPath;
            }
            try {
                result.setConfigDocument(NetUtilities.readToDocument(configPath, false));
            }
            catch (XMLParseException e) {
                throw new DAIURLContentException(configPath, e);
            }
        }
        if ((properties = this.getProperties(activityElement)) != null) {
            result.setProperties(properties);
        }
        if ((nodes = activityElement.getElementsByTagName("description")).getLength() > 0) {
            Element descriptionElement = (Element)nodes.item(0);
            String description = XMLUtilities.getTextContent(nodes.item(0));
            result.setDescription(description);
        }
        return result;
    }

    private Properties getProperties(Element activityElement) {
        Properties result = null;
        NodeList nodes = activityElement.getElementsByTagName("property");
        if (nodes.getLength() > 0) {
            result = new Properties();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element property = (Element)nodes.item(i);
                String key = property.getAttribute("key");
                String value = property.getAttribute("value");
                result.put(key, value);
            }
        }
        return result;
    }

    private Document getBasePerformDocumentSchema(Document configDoc) throws DAIMalformedURLException, DAIURLReadIOException, DAIURLContentException {
        NodeList nodes = configDoc.getDocumentElement().getElementsByTagName("basePerformDocumentSchema");
        Element performDocumentSchema = (Element)nodes.item(0);
        String location = performDocumentSchema.getAttribute("location");
        if (DAILOG.isDebugEnabled()) {
            DAILOG.debug("Loading base perform document schema from: " + location);
        }
        try {
            Document schema = NetUtilities.readToDocument(location, false);
            return schema;
        }
        catch (XMLParseException e) {
            throw new DAIURLContentException(location, e);
        }
    }
}

