/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.service.resource;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import uk.org.ogsadai.service.resource.ResourceEvent;
import uk.org.ogsadai.service.resource.ResourceListener;

public class ResourceEventDispatcher
implements ResourceListener {
    private static final String COPYRIGHT_NOTICE = "(c) The University of Edinburgh 2002 - 2006.";
    private final Collection mListeners = new HashSet();

    public void sessionCreated(ResourceEvent event) {
        Iterator i = this.mListeners.iterator();
        while (i.hasNext()) {
            ResourceListener listener = (ResourceListener)i.next();
            listener.sessionCreated(event);
        }
    }

    public void sessionTerminated(ResourceEvent event) {
        Iterator i = this.mListeners.iterator();
        while (i.hasNext()) {
            ResourceListener listener = (ResourceListener)i.next();
            listener.sessionTerminated(event);
        }
    }

    public synchronized void addListener(ResourceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.mListeners.add(listener);
    }
}

