/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.service.resource;

import org.w3c.dom.Document;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivityFactory;
import uk.org.ogsadai.activity.ActivityFactoryImpl;
import uk.org.ogsadai.activity.ActivityRequestFactory;
import uk.org.ogsadai.activity.ResponseDocumentBuilder;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.properties.Properties;
import uk.org.ogsadai.common.properties.PropertiesImpl;
import uk.org.ogsadai.common.properties.Property;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.dataresource.DataResourceAccessor;
import uk.org.ogsadai.engine.ConcurrencySettings;
import uk.org.ogsadai.engine.Engine;
import uk.org.ogsadai.engine.EngineConfiguration;
import uk.org.ogsadai.engine.EngineConfigurationImpl;
import uk.org.ogsadai.engine.Request;
import uk.org.ogsadai.engine.RequestAuthorizationException;
import uk.org.ogsadai.engine.RequestContext;
import uk.org.ogsadai.engine.RequestEngine;
import uk.org.ogsadai.engine.RequestExecutionException;
import uk.org.ogsadai.engine.RequestFactory;
import uk.org.ogsadai.engine.RequestSpecificationException;
import uk.org.ogsadai.exception.DAIException;
import uk.org.ogsadai.service.authorization.AccessAuthorizer;
import uk.org.ogsadai.service.authorization.ActivityAccessAuthorizationException;
import uk.org.ogsadai.service.resource.ResourceCreationException;
import uk.org.ogsadai.service.resource.ResourceRequestAuthorizationException;
import uk.org.ogsadai.service.resource.ResourceRequestExecutionException;
import uk.org.ogsadai.service.resource.ResourceRequestSpecificationException;
import uk.org.ogsadai.service.resource.config.ActivitiesConfig;
import uk.org.ogsadai.sessions.SessionComponentFactory;
import uk.org.ogsadai.sessions.SessionCoordinator;
import uk.org.ogsadai.sessions.SessionLookupException;
import uk.org.ogsadai.sessions.SessionNotFoundException;
import uk.org.ogsadai.sessions.SessionStreamClosedException;
import uk.org.ogsadai.sessions.SessionStreamID;
import uk.org.ogsadai.sessions.SessionStreamIOException;
import uk.org.ogsadai.sessions.SessionStreamManager;
import uk.org.ogsadai.sessions.SessionStreamNotFoundException;
import uk.org.ogsadai.sessions.SessionStreamRequestNotProcessingException;
import uk.org.ogsadai.sessions.SimpleSessionStreamManager;

public class DataServiceResource {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2005-2006.";
    private static DAILogger LOG = DAILogger.getLogger(DataServiceResource.class);
    private Object mID = null;
    private Properties mProperties;
    private final SessionStreamManager mSessionStreamManager;
    private final ActivityFactory mActivityFactory;
    private final DataResourceAccessor mDataResourceAccessor;
    private final SessionCoordinator mSessionCoordinator;
    private final RequestFactory mRequestFactory;
    private Engine mEngine;
    private EngineConfiguration mEngineConfiguration;

    public DataServiceResource(Object id, ActivitiesConfig activitiesConfig, DataResourceAccessor dataResourceAccessor, SessionComponentFactory sessionComponentFactory, ConcurrencySettings concurrencySettings, AccessAuthorizer accessAuthorizer) throws ResourceCreationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating new DataServiceResource " + id);
        }
        if (id == null || id.equals("")) {
            throw new IllegalArgumentException("id must not be null or empty");
        }
        if (activitiesConfig == null) {
            throw new IllegalArgumentException("activitiesConfig must not be null");
        }
        if (dataResourceAccessor == null) {
            throw new IllegalArgumentException("dataResourceAccessor must not be null");
        }
        if (sessionComponentFactory == null) {
            throw new IllegalArgumentException("sessionComponentFactory must not be null");
        }
        if (concurrencySettings == null) {
            throw new IllegalArgumentException("concurrencySettings must not be null");
        }
        this.mID = id;
        this.mDataResourceAccessor = dataResourceAccessor;
        this.mProperties = new PropertiesImpl();
        this.mActivityFactory = new ActivityFactoryImpl(activitiesConfig);
        this.mRequestFactory = new ActivityRequestFactory(this.mActivityFactory, accessAuthorizer);
        try {
            sessionComponentFactory.setResourceProperties(this.mProperties);
            sessionComponentFactory.setDataResourceAccessor(this.mDataResourceAccessor);
            this.mSessionCoordinator = sessionComponentFactory.getSessionCoordinator();
        }
        catch (DAIException e) {
            throw new ResourceCreationException(id.toString(), e);
        }
        this.mEngineConfiguration = new EngineConfigurationImpl(this.mSessionCoordinator, concurrencySettings);
        this.mEngineConfiguration.setDataResourceAccessor(this.mDataResourceAccessor);
        this.mEngine = new RequestEngine(this.mEngineConfiguration);
        this.mSessionStreamManager = new SimpleSessionStreamManager(this.mSessionCoordinator.getSessionManager());
        this.addProperties();
    }

    private void addProperties() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding data resource accessor properties...");
        }
        Property[] drProps = this.mDataResourceAccessor.getProperties();
        for (int i = 0; i < drProps.length; ++i) {
            this.mProperties.put(drProps[i]);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding activity factory properties...");
        }
        Property[] activityProperties = this.mActivityFactory.getProperties();
        for (int i = 0; i < activityProperties.length; ++i) {
            this.mProperties.put(activityProperties[i]);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Properties added");
        }
    }

    public Object getID() {
        return this.mID;
    }

    public Properties getProperties() {
        return this.mProperties;
    }

    public SessionStreamManager getSessionStreamManager() {
        return this.mSessionStreamManager;
    }

    public Document perform(Document performDocument, RequestContext requestContext) throws ResourceRequestAuthorizationException, ResourceRequestSpecificationException, ResourceRequestExecutionException {
        Document response = null;
        ResponseDocumentBuilder builder = new ResponseDocumentBuilder();
        Request request = null;
        requestContext.setResourceID(this.mID.toString());
        try {
            request = this.mRequestFactory.createRequest(performDocument, requestContext);
        }
        catch (RequestSpecificationException e) {
            throw new ResourceRequestSpecificationException(this.mID, (Throwable)e);
        }
        catch (RequestExecutionException e) {
            throw new ResourceRequestExecutionException(this.mID, (Throwable)e);
        }
        catch (ActivityAccessAuthorizationException e) {
            throw new ResourceRequestAuthorizationException(this.mID, (Throwable)e);
        }
        try {
            this.mEngine.perform(request, requestContext, builder);
        }
        catch (RequestAuthorizationException e) {
            throw new ResourceRequestAuthorizationException(this.mID, (Throwable)e);
        }
        catch (RequestSpecificationException e) {
            throw new ResourceRequestSpecificationException(this.mID, (Throwable)e);
        }
        catch (RequestExecutionException e) {
            throw new ResourceRequestExecutionException(this.mID, (Throwable)e);
        }
        response = builder.getResponseDocument();
        if (requestContext.hasError()) {
            Throwable cause = requestContext.getCauseOfError();
            if (cause instanceof RequestExecutionException) {
                throw new ResourceRequestExecutionException(this.mID, cause);
            }
            if (cause instanceof ActivityExecutionException) {
                throw new ResourceRequestExecutionException(this.mID, (Throwable)new RequestExecutionException(cause));
            }
            throw new ResourceRequestSpecificationException(this.mID, (Throwable)new RequestSpecificationException(cause, XMLUtilities.xmlDOMToString(response)));
        }
        return response;
    }

    public void terminate() throws ResourceRequestAuthorizationException, ResourceRequestSpecificationException, ResourceRequestExecutionException {
        this.mEngine.terminate();
    }

    public Object getFully(SessionStreamID id) throws ResourceRequestAuthorizationException, ResourceRequestExecutionException, ResourceRequestSpecificationException {
        try {
            return this.mSessionStreamManager.getFully(id);
        }
        catch (SessionNotFoundException e) {
            throw new ResourceRequestSpecificationException(this.mID, (Throwable)e);
        }
        catch (SessionStreamNotFoundException e) {
            throw new ResourceRequestSpecificationException(this.mID, (Throwable)e);
        }
        catch (SessionStreamRequestNotProcessingException e) {
            throw new ResourceRequestSpecificationException(this.mID, (Throwable)e);
        }
        catch (SessionLookupException e) {
            throw new ResourceRequestExecutionException(this.mID, (Throwable)e);
        }
        catch (SessionStreamIOException e) {
            throw new ResourceRequestExecutionException(this.mID, (Throwable)e);
        }
    }

    public Object getNBlocks(SessionStreamID id, int numberOfBlocks) throws ResourceRequestAuthorizationException, ResourceRequestExecutionException, ResourceRequestSpecificationException {
        try {
            return this.mSessionStreamManager.getNBlocks(id, numberOfBlocks);
        }
        catch (SessionNotFoundException e) {
            throw new ResourceRequestSpecificationException(this.mID, (Throwable)e);
        }
        catch (SessionStreamNotFoundException e) {
            throw new ResourceRequestSpecificationException(this.mID, (Throwable)e);
        }
        catch (SessionStreamRequestNotProcessingException e) {
            throw new ResourceRequestSpecificationException(this.mID, (Throwable)e);
        }
        catch (SessionLookupException e) {
            throw new ResourceRequestExecutionException(this.mID, (Throwable)e);
        }
        catch (SessionStreamIOException e) {
            throw new ResourceRequestExecutionException(this.mID, (Throwable)e);
        }
    }

    public Object getBlock(SessionStreamID id) throws ResourceRequestAuthorizationException, ResourceRequestExecutionException, ResourceRequestSpecificationException {
        return this.getNBlocks(id, 1);
    }

    public void putBlock(SessionStreamID id, Object data) throws ResourceRequestAuthorizationException, ResourceRequestExecutionException, ResourceRequestSpecificationException {
        try {
            this.mSessionStreamManager.putBlock(id, data);
        }
        catch (SessionNotFoundException e) {
            throw new ResourceRequestSpecificationException(this.mID, (Throwable)e);
        }
        catch (SessionStreamNotFoundException e) {
            throw new ResourceRequestSpecificationException(this.mID, (Throwable)e);
        }
        catch (SessionStreamClosedException e) {
            throw new ResourceRequestSpecificationException(this.mID, (Throwable)e);
        }
        catch (SessionStreamRequestNotProcessingException e) {
            throw new ResourceRequestSpecificationException(this.mID, (Throwable)e);
        }
        catch (SessionLookupException e) {
            throw new ResourceRequestExecutionException(this.mID, (Throwable)e);
        }
    }

    public void putFully(SessionStreamID id, Object data) throws ResourceRequestAuthorizationException, ResourceRequestExecutionException, ResourceRequestSpecificationException {
        try {
            this.mSessionStreamManager.putFully(id, data);
        }
        catch (SessionNotFoundException e) {
            throw new ResourceRequestSpecificationException(this.mID, (Throwable)e);
        }
        catch (SessionStreamNotFoundException e) {
            throw new ResourceRequestSpecificationException(this.mID, (Throwable)e);
        }
        catch (SessionStreamClosedException e) {
            throw new ResourceRequestSpecificationException(this.mID, (Throwable)e);
        }
        catch (SessionStreamRequestNotProcessingException e) {
            throw new ResourceRequestSpecificationException(this.mID, (Throwable)e);
        }
        catch (SessionLookupException e) {
            throw new ResourceRequestExecutionException(this.mID, (Throwable)e);
        }
    }
}

