/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.service.authorization;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.common.files.DAIFileNotFoundException;
import uk.org.ogsadai.common.files.FileUtilities;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.exception.DAIClassCreateException;
import uk.org.ogsadai.exception.DAIClassMissingInterfaceException;
import uk.org.ogsadai.exception.DAIClassNotFoundException;
import uk.org.ogsadai.service.authorization.AccessAuthorizer;
import uk.org.ogsadai.service.authorization.AuthorizationInitialisationException;
import uk.org.ogsadai.service.authorization.NullAuthorizer;

public class AuthorizationFactory {
    private static final String COPYRIGHT_NOTICE = "(c) The University of Edinburgh 2006.";
    private static final DAILogger LOG = DAILogger.getLogger(AuthorizationFactory.class);

    public static AccessAuthorizer createAuthorization(String configFile) throws AuthorizationInitialisationException {
        AccessAuthorizer authority = null;
        if (configFile != null) {
            try {
                FileUtilities.fileExists(new File(configFile));
            }
            catch (DAIFileNotFoundException e) {
                throw new AuthorizationInitialisationException(e);
            }
            String impl = null;
            String configuration = null;
            try {
                Document doc = XMLUtilities.xmlFileToDOM(configFile, false);
                Element root = doc.getDocumentElement();
                NodeList nodes = root.getElementsByTagName("authorizer");
                if (nodes.getLength() > 0) {
                    Element element = (Element)nodes.item(0);
                    impl = element.getAttribute("implementation");
                    configuration = element.getAttribute("config");
                }
            }
            catch (Throwable e) {
                throw new AuthorizationInitialisationException(e);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Trying to load authorization, class = " + impl + ", config = " + configuration);
            }
            if (impl == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No implementation class specified.");
                }
                throw new AuthorizationInitialisationException();
            }
            try {
                Class<?> clazz = Class.forName(impl);
                Constructor<?> constructor = clazz.getConstructor(String.class);
                authority = (AccessAuthorizer)constructor.newInstance(configuration);
            }
            catch (ClassNotFoundException e) {
                throw new AuthorizationInitialisationException(new DAIClassNotFoundException(impl));
            }
            catch (InstantiationException e) {
                throw new AuthorizationInitialisationException(new DAIClassCreateException(impl, e));
            }
            catch (InvocationTargetException e) {
                throw new AuthorizationInitialisationException(new DAIClassCreateException(impl, e));
            }
            catch (NoSuchMethodException e) {
                throw new AuthorizationInitialisationException(new DAIClassCreateException(impl, e));
            }
            catch (IllegalAccessException e) {
                throw new AuthorizationInitialisationException(new DAIClassCreateException(impl, e));
            }
            catch (ClassCastException e) {
                throw new AuthorizationInitialisationException(new DAIClassMissingInterfaceException(impl, AccessAuthorizer.class.getName()));
            }
        }
        authority = new NullAuthorizer();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loaded authorization class: " + authority.getClass().getName());
        }
        return authority;
    }
}

