/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.exception;

import uk.org.ogsadai.common.msgs.DAIUniqueID;
import uk.org.ogsadai.common.msgs.MessageLoader;
import uk.org.ogsadai.exception.DAIExceptionInformation;
import uk.org.ogsadai.exception.ErrorID;
import uk.org.ogsadai.exception.ServerException;

public class InternalFaultException
extends Exception
implements DAIExceptionInformation {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    private static final ErrorID ERROR_ID = ErrorID.INTERNAL_FAULT;
    private Object[] mParameters;
    private String mMessage;
    private String mLocalizedMessage;
    private DAIUniqueID mUniqueID;

    public InternalFaultException(ServerException cause) {
        this.mUniqueID = cause.getExceptionID();
        this.mParameters = new Object[]{this.mUniqueID.toString()};
        this.mMessage = MessageLoader.getMessage(ERROR_ID, this.mParameters, this.mUniqueID);
        this.mLocalizedMessage = MessageLoader.getLocalizedMessage(ERROR_ID, this.mParameters, this.mUniqueID);
    }

    public String getLocalizedMessage() {
        return this.mLocalizedMessage;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public DAIUniqueID getExceptionID() {
        return this.mUniqueID;
    }

    public ErrorID getErrorID() {
        return ERROR_ID;
    }

    public Object[] getParameters() {
        return this.mParameters;
    }

    public boolean hasChild() {
        return false;
    }
}

