/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.engine.controlflow;

import java.util.Iterator;
import uk.org.ogsadai.activity.ActivityContext;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.engine.RequestExecutionException;
import uk.org.ogsadai.engine.RequestSpecificationException;
import uk.org.ogsadai.engine.ResponseBuilder;
import uk.org.ogsadai.engine.controlflow.CompositeRequestComponent;
import uk.org.ogsadai.engine.controlflow.RequestComponent;

public class SequenceRequestComponent
extends CompositeRequestComponent
implements RequestComponent {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private static final DAILogger LOG = DAILogger.getLogger(SequenceRequestComponent.class);
    private final String mName;

    public SequenceRequestComponent(String name) {
        this.mName = name;
    }

    public void process(ActivityContext context, ResponseBuilder responseBuilder) throws RequestSpecificationException, RequestExecutionException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting to process sequence of request components.");
        }
        try {
            Iterator i = this.children().iterator();
            while (i.hasNext()) {
                RequestComponent component = (RequestComponent)i.next();
                component.process(context, responseBuilder);
            }
        }
        catch (RequestSpecificationException e) {
            responseBuilder.buildError(this.mName, e);
            throw e;
        }
        catch (RequestExecutionException e) {
            responseBuilder.buildError(this.mName, e);
            throw e;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished processing sequence of request components.");
        }
    }

    public void terminate() {
        Iterator i = this.children().iterator();
        while (i.hasNext()) {
            ((RequestComponent)i.next()).terminate();
        }
    }
}

