/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.engine.controlflow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityPipelineRequestComponent;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.engine.RequestCreationException;
import uk.org.ogsadai.engine.RequestSpecificationException;
import uk.org.ogsadai.engine.controlflow.CompositeRequestComponent;
import uk.org.ogsadai.engine.controlflow.FlowRequestComponent;
import uk.org.ogsadai.engine.controlflow.RequestComponent;
import uk.org.ogsadai.engine.controlflow.RequestComponentFactory;
import uk.org.ogsadai.engine.controlflow.SequenceRequestComponent;

public class RequestComponentFactoryImpl
implements RequestComponentFactory {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    private static final DAILogger LOG = DAILogger.getLogger(RequestComponentFactoryImpl.class);

    public RequestComponent createRequestComponent(Activity[] activities, Document requestDocument) throws RequestCreationException, RequestSpecificationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating composite RequestComponent for request");
        }
        Element rootElement = requestDocument.getDocumentElement();
        ArrayList<Activity> activitiesList = new ArrayList<Activity>(Arrays.asList(activities));
        Collection pipelines = this.createActivityPipelines(activitiesList);
        if (LOG.isDebugEnabled()) {
            LOG.debug(pipelines.size() + " activity pipelines have been identified in the request");
        }
        FlowRequestComponent rootComponent = new FlowRequestComponent("root");
        this.addChildren(rootElement, rootComponent, pipelines);
        return rootComponent;
    }

    private Collection createActivityPipelines(List activities) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating activity pipeline request components...");
        }
        ArrayList<ActivityPipelineRequestComponent> pipelines = new ArrayList<ActivityPipelineRequestComponent>();
        while (activities.size() > 0) {
            Activity activity = (Activity)activities.remove(0);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Constructing pipeline containing activity: " + activity.getName());
            }
            ActivityPipelineRequestComponent pipeline = new ActivityPipelineRequestComponent();
            pipeline.addActivity(activity);
            pipelines.add(pipeline);
            this.searchForConnections(activity, activities, pipeline);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created " + pipelines.size() + " activity pipeline request components");
        }
        return pipelines;
    }

    private void searchForConnections(Activity activity, List activities, ActivityPipelineRequestComponent pipeline) {
        ArrayList tempActivities = new ArrayList(activities);
        Iterator i = tempActivities.iterator();
        while (i.hasNext()) {
            Activity activityB = (Activity)i.next();
            if (!activity.connectsTo(activityB)) continue;
            pipeline.addActivity(activityB);
            activities.remove(activityB);
            this.searchForConnections(activityB, activities, pipeline);
        }
    }

    public void addChildren(Element parentElement, RequestComponent parentComponent, Collection pipelines) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding any children to a " + parentComponent.getClass().getName());
        }
        Iterator i = XMLUtilities.getChildElementIterator(parentElement);
        while (i.hasNext()) {
            CompositeRequestComponent childComponent;
            String name;
            Element childElement = (Element)i.next();
            String type = childElement.getLocalName();
            if (type.equals("sequence")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding a SequenceRequestComponent to composite");
                }
                name = childElement.getAttribute("name");
                childComponent = new SequenceRequestComponent(name);
                parentComponent.add(childComponent);
                this.addChildren(childElement, childComponent, pipelines);
                continue;
            }
            if (type.equals("flow")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding a FlowRequestComponent to composite");
                }
                name = childElement.getAttribute("name");
                childComponent = new FlowRequestComponent(name);
                parentComponent.add(childComponent);
                this.addChildren(childElement, childComponent, pipelines);
                continue;
            }
            if (type.equals("documentation") || type.endsWith("session")) continue;
            this.addActivityPipeline(childElement, parentComponent, pipelines);
        }
    }

    private void addActivityPipeline(Element activityElement, RequestComponent component, Collection pipelines) {
        String activityName = activityElement.getAttribute("name");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looking for pipeline containing " + activityElement.getLocalName() + " activity named: " + activityName);
        }
        Iterator i = pipelines.iterator();
        while (i.hasNext()) {
            ActivityPipelineRequestComponent pipelineComponent = (ActivityPipelineRequestComponent)i.next();
            if (!pipelineComponent.containsActivity(activityName)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding an ActivityPipelineRequestComponent to composite");
            }
            component.add(pipelineComponent);
            i.remove();
        }
    }
}

