/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.engine.controlflow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uk.org.ogsadai.activity.ActivityContext;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.engine.RequestExecutionException;
import uk.org.ogsadai.engine.RequestSpecificationException;
import uk.org.ogsadai.engine.ResponseBuilder;
import uk.org.ogsadai.engine.controlflow.CompositeRequestComponent;
import uk.org.ogsadai.engine.controlflow.RequestComponent;

public class FlowRequestComponent
extends CompositeRequestComponent
implements RequestComponent {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private static final DAILogger LOG = DAILogger.getLogger(FlowRequestComponent.class);
    private List mThreads = new ArrayList();
    private Exception mCause;
    private final String mName;

    public FlowRequestComponent(String name) {
        this.mName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ActivityContext context, ResponseBuilder responseBuilder) throws RequestSpecificationException, RequestExecutionException {
        List children;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting to process flow of request components.");
        }
        if ((children = super.children()).size() > 0) {
            FlowRequestComponent flowRequestComponent = this;
            synchronized (flowRequestComponent) {
                this.spawnThreads(children, context, responseBuilder);
                RequestComponent firstChild = (RequestComponent)super.children().get(0);
                firstChild.process(context, responseBuilder);
            }
            this.joinThreads();
            if (this.hasException()) {
                this.raiseException();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished processing flow of request components.");
        }
    }

    private void spawnThreads(List children, final ActivityContext context, final ResponseBuilder responseBuilder) {
        for (int i = 1; i < children.size(); ++i) {
            final RequestComponent component = (RequestComponent)children.get(i);
            Thread thread = new Thread(){

                public void run() {
                    try {
                        component.process(context, responseBuilder);
                    }
                    catch (RequestSpecificationException e) {
                        FlowRequestComponent.this.reportException(e, responseBuilder);
                    }
                    catch (RequestExecutionException e) {
                        FlowRequestComponent.this.reportException(e, responseBuilder);
                    }
                }
            };
            this.mThreads.add(thread);
            thread.start();
        }
    }

    private void joinThreads() {
        try {
            Iterator i = this.mThreads.iterator();
            while (i.hasNext()) {
                ((Thread)i.next()).join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void reportException(Exception cause, ResponseBuilder responseBuilder) {
        this.mCause = cause;
        responseBuilder.buildError(this.mName, cause);
        this.terminate();
    }

    private boolean hasException() {
        return this.mCause != null;
    }

    private void raiseException() throws RequestSpecificationException, RequestExecutionException {
        if (this.mCause instanceof RequestSpecificationException) {
            throw (RequestSpecificationException)this.mCause;
        }
        throw (RequestExecutionException)this.mCause;
    }

    public synchronized void terminate() {
        Iterator i = super.children().iterator();
        while (i.hasNext()) {
            ((RequestComponent)i.next()).terminate();
        }
        this.joinThreads();
    }
}

