/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.engine.controlflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import uk.org.ogsadai.activity.ActivityContext;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.engine.RequestExecutionException;
import uk.org.ogsadai.engine.RequestSpecificationException;
import uk.org.ogsadai.engine.ResponseBuilder;
import uk.org.ogsadai.engine.controlflow.RequestComponent;
import uk.org.ogsadai.sessions.Session;

public abstract class CompositeRequestComponent
implements RequestComponent {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private static final DAILogger LOG = DAILogger.getLogger(CompositeRequestComponent.class);
    private final List mChildren = new ArrayList();

    public void add(RequestComponent child) {
        this.mChildren.add(child);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Child added to " + this.getClass().getName() + " (size=" + this.mChildren.size() + ")");
        }
    }

    public List children() {
        return Collections.unmodifiableList(this.mChildren);
    }

    public void initialise(ActivityContext context, Session session, ResponseBuilder responseBuilder) throws RequestSpecificationException, RequestExecutionException {
        Iterator i = this.children().iterator();
        while (i.hasNext()) {
            RequestComponent component = (RequestComponent)i.next();
            component.initialise(context, session, responseBuilder);
        }
    }

    public boolean generatesResultData() {
        Iterator i = this.mChildren.iterator();
        while (i.hasNext()) {
            RequestComponent component = (RequestComponent)i.next();
            if (!component.generatesResultData()) continue;
            return true;
        }
        return false;
    }
}

