/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.engine;

import java.util.NoSuchElementException;
import uk.org.ogsadai.common.CircularBuffer;
import uk.org.ogsadai.engine.Pipe;

public class SynchronizedPipe
implements Pipe {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private final CircularBuffer mBuffer;
    private Object mNext;
    private boolean mFirstCall = true;

    public SynchronizedPipe(int bufferSize) {
        this.mBuffer = new CircularBuffer(bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object next() {
        Object block = this.nextBlock();
        if (block == null) {
            throw new NoSuchElementException("The pipe has been closed and there are no more blocks to read.");
        }
        SynchronizedPipe synchronizedPipe = this;
        synchronized (synchronizedPipe) {
            this.readNext();
        }
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object nextBlock() {
        SynchronizedPipe synchronizedPipe = this;
        synchronized (synchronizedPipe) {
            if (this.mFirstCall) {
                this.readNext();
            }
            return this.mNext;
        }
    }

    private void readNext() {
        if (this.mFirstCall) {
            this.mFirstCall = false;
        }
        try {
            this.mNext = this.mBuffer.read();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() {
        SynchronizedPipe synchronizedPipe = this;
        synchronized (synchronizedPipe) {
            if (this.mFirstCall) {
                this.readNext();
            }
            return this.mNext != null;
        }
    }

    public void put(Object block) {
        try {
            this.mBuffer.write(block);
            block = null;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void close() {
        this.mBuffer.close();
    }

    public synchronized boolean isOpen() {
        throw new UnsupportedOperationException("The isOpen method is unsupported in this pipe implementation.");
    }
}

