/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.engine;

import java.util.Observable;
import java.util.Observer;
import uk.org.ogsadai.engine.Request;
import uk.org.ogsadai.engine.RequestEngine;

public class RequestEngineObserver
implements Observer {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) The University of Edinburgh 2002 - 2005.";
    private boolean mWaiting = true;
    private RequestEngine mEngine;

    public RequestEngineObserver(RequestEngine engine) {
        this.mEngine = engine;
        this.mEngine.addObserver(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Observable engine, Object load) {
        RequestEngineObserver requestEngineObserver = this;
        synchronized (requestEngineObserver) {
            this.mWaiting = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        RequestEngineObserver requestEngineObserver = this;
        synchronized (requestEngineObserver) {
            this.mWaiting = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForEngine() {
        RequestEngineObserver requestEngineObserver = this;
        synchronized (requestEngineObserver) {
            while (this.mWaiting) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    this.mWaiting = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilProcessing(Request request) {
        RequestEngineObserver requestEngineObserver = this;
        synchronized (requestEngineObserver) {
            while (!this.mEngine.isProcessing(request)) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilQueued(Request request) {
        RequestEngineObserver requestEngineObserver = this;
        synchronized (requestEngineObserver) {
            while (!this.mEngine.isQueueing(request)) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFlushed(Request request) {
        RequestEngineObserver requestEngineObserver = this;
        synchronized (requestEngineObserver) {
            while (this.mEngine.isQueueing(request) || this.mEngine.isProcessing(request)) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilIdle() {
        RequestEngineObserver requestEngineObserver = this;
        synchronized (requestEngineObserver) {
            while (this.mEngine.activeLoad() > 0 || this.mEngine.latentLoad() > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

